package examples.tapestry.page;

import java.lang.reflect.InvocationTargetException;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.html.BasePage;
import org.apache.tapestry.valid.ValidationDelegate;

import examples.tapestry.CalcService;

public abstract class Home extends BasePage {
    
    protected abstract CalcService getCalcService();
    protected abstract int getArg1();
    protected abstract int getArg2();

    public void calculate(IRequestCycle cycle) {
        ValidationDelegate delegate = (ValidationDelegate)getBeans().getBean("delegate");
        if( delegate.getHasErrors() ) return ;
        
        int result  = getCalcService().calc2( getArg1(), getArg2() );
        Result next = (Result) cycle.getPage("Calc");
        try {
            BeanUtils.setProperty(next, "arg1",   new Integer(getArg1()));
            BeanUtils.setProperty(next, "arg2",   new Integer(getArg2()));
            BeanUtils.setProperty(next, "result", new Integer(result));
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        } catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        
        cycle.activate(next);
    }
}