/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.valid;

import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.form.AbstractTextField;
import org.apache.tapestry.form.Form;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.html.Body;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.IValidator;
import org.apache.tapestry.valid.ValidatorException;

public abstract class ValidField
extends AbstractTextField
implements IFormComponent {
    private static final String SELECTED_ATTRIBUTE_NAME = "org.apache.tapestry.component.html.valid.SelectedFieldSet";

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public abstract String getDisplayName();

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        boolean rendering;
        IForm form = this.getForm(cycle);
        IValidationDelegate delegate = form.getDelegate();
        if (delegate == null) {
            throw new ApplicationRuntimeException(Tapestry.format("ValidField.no-delegate", this.getExtendedId(), this.getForm().getExtendedId()), this, null, null);
        }
        IValidator validator = this.getValidator();
        if (validator == null) {
            throw Tapestry.createRequiredParameterException(this, "validator");
        }
        boolean bl = rendering = !cycle.isRewinding();
        if (rendering) {
            delegate.writePrefix(writer, cycle, this, validator);
        }
        super.renderComponent(writer, cycle);
        if (rendering) {
            delegate.writeSuffix(writer, cycle, this, validator);
        }
        if (rendering && delegate.isInError()) {
            this.addSelect(cycle);
        }
    }

    protected void beforeCloseTag(IMarkupWriter writer, IRequestCycle cycle) {
        IValidator validator = this.getValidator();
        validator.renderValidatorContribution(this, writer, cycle);
        this.getForm().getDelegate().writeAttributes(writer, cycle, this, validator);
    }

    protected void addSelect(IRequestCycle cycle) {
        if (cycle.getAttribute(SELECTED_ATTRIBUTE_NAME) != null) {
            return;
        }
        Body body = Body.get(cycle);
        if (body == null) {
            return;
        }
        IForm form = Form.get(cycle);
        String formName = form.getName();
        String textFieldName = this.getName();
        String fullName = "document." + formName + "." + textFieldName;
        body.addInitializationScript(fullName + ".focus();");
        body.addInitializationScript(fullName + ".select();");
        cycle.setAttribute(SELECTED_ATTRIBUTE_NAME, Boolean.TRUE);
    }

    protected String readValue() {
        IValidationDelegate delegate = this.getForm().getDelegate();
        if (delegate.isInError()) {
            return delegate.getFieldInputValue();
        }
        Object value = this.getValue();
        String result = this.getValidator().toString(this, value);
        if (Tapestry.isBlank(result) && this.getValidator().isRequired()) {
            this.addSelect(this.getPage().getRequestCycle());
        }
        return result;
    }

    protected void updateValue(String value) {
        Object objectValue = null;
        IValidationDelegate delegate = this.getForm().getDelegate();
        delegate.recordFieldInputValue(value);
        try {
            objectValue = this.getValidator().toObject(this, value);
        }
        catch (ValidatorException ex) {
            delegate.record(ex);
            return;
        }
        this.setValue(objectValue);
    }

    public abstract IValidator getValidator();
}

