/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.valid;

import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.BindingException;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.form.Form;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.valid.IValidationDelegate;

public abstract class FieldLabel
extends AbstractComponent {
    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        IForm form;
        if (cycle.isRewinding()) {
            return;
        }
        IFormComponent field = this.getField();
        String displayName = this.getDisplayName();
        if (displayName == null) {
            if (field == null) {
                throw Tapestry.createRequiredParameterException(this, "field");
            }
            displayName = field.getDisplayName();
            if (displayName == null) {
                String msg = Tapestry.format("FieldLabel.no-display-name", field.getExtendedId());
                throw new BindingException(msg, this, null, this.getBinding("field"), null);
            }
        }
        if ((form = Form.get(cycle)) == null) {
            String msg = Tapestry.getMessage("FieldLabel.must-be-contained-by-form");
            throw new ApplicationRuntimeException(msg, this, null, null);
        }
        IValidationDelegate delegate = form.getDelegate();
        if (delegate == null) {
            String msg = Tapestry.format("FieldLabel.no-delegate", this.getExtendedId(), form.getExtendedId());
            throw new ApplicationRuntimeException(msg, this, null, null);
        }
        delegate.writeLabelPrefix(field, writer, cycle);
        if (this.getRaw()) {
            writer.printRaw(displayName);
        } else {
            writer.print(displayName);
        }
        delegate.writeLabelSuffix(field, writer, cycle);
    }

    public abstract String getDisplayName();

    public abstract IFormComponent getField();

    public abstract boolean getRaw();
}

