/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.parse;

import org.apache.tapestry.Tapestry;
import org.apache.tapestry.parse.AbstractSpecificationRule;
import org.apache.tapestry.util.xml.DocumentParseException;
import org.xml.sax.Attributes;

public class SetExtendedPropertyRule
extends AbstractSpecificationRule {
    private String _attributeName;
    private String _propertyName;
    private boolean _required;
    private boolean _valueSet;

    public SetExtendedPropertyRule(String attributeName, String propertyName, boolean required) {
        this._attributeName = attributeName;
        this._propertyName = propertyName;
        this._required = required;
    }

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        String value = this.getValue(attributes, this._attributeName);
        if (value != null) {
            this.setProperty(this._propertyName, value);
            this._valueSet = true;
        }
    }

    public void body(String namespace, String name, String text) throws Exception {
        if (Tapestry.isBlank(text)) {
            return;
        }
        if (this._valueSet) {
            throw new DocumentParseException(Tapestry.format("SpecificationParser.no-attribute-and-body", this._attributeName, name), this.getResourceLocation());
        }
        this.setProperty(this._propertyName, text.trim());
        this._valueSet = true;
    }

    public void end(String namespace, String name) throws Exception {
        if (!this._valueSet && this._required) {
            throw new DocumentParseException(Tapestry.format("SpecificationParser.required-extended-attribute", name, this._attributeName), this.getResourceLocation());
        }
        this._valueSet = false;
    }
}

