/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.binding;

import java.util.Map;
import ognl.ClassResolver;
import ognl.Ognl;
import ognl.OgnlException;
import ognl.TypeConverter;
import org.apache.tapestry.BindingException;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.ILocation;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.binding.AbstractBinding;
import org.apache.tapestry.spec.BeanLifecycle;
import org.apache.tapestry.spec.IApplicationSpecification;
import org.apache.tapestry.spec.IBeanSpecification;
import org.apache.tapestry.util.StringSplitter;
import org.apache.tapestry.util.prop.OgnlUtils;

public class ExpressionBinding
extends AbstractBinding {
    private IComponent _root;
    private String _expression;
    private boolean _invariant = false;
    private Object _cachedValue;
    private Object _parsedExpression;
    private boolean _initialized;
    private IResourceResolver _resolver;
    private Map _context;
    static /* synthetic */ Class class$ognl$TypeConverter;

    public ExpressionBinding(IResourceResolver resolver, IComponent root, String expression, ILocation location) {
        super(location);
        this._resolver = resolver;
        this._root = root;
        this._expression = expression;
    }

    public String getExpression() {
        return this._expression;
    }

    public IComponent getRoot() {
        return this._root;
    }

    public Object getObject() {
        this.initialize();
        if (this._invariant) {
            return this._cachedValue;
        }
        return this.resolveProperty();
    }

    private Object resolveProperty() {
        try {
            return Ognl.getValue((Object)this._parsedExpression, (Map)this.getOgnlContext(), (Object)this._root);
        }
        catch (OgnlException t) {
            throw new BindingException(Tapestry.format("ExpressionBinding.unable-to-resolve-expression", this._expression, this._root), this, (Throwable)t);
        }
    }

    private Map getOgnlContext() {
        IApplicationSpecification appSpec;
        if (this._context == null) {
            this._context = Ognl.createDefaultContext((Object)this._root, (ClassResolver)this._resolver);
        }
        if (this._root.getPage() != null && this._root.getPage().getEngine() != null && (appSpec = this._root.getPage().getEngine().getSpecification()) != null && appSpec.checkExtension("org.apache.tapestry.ognl-type-converter")) {
            TypeConverter typeConverter = (TypeConverter)appSpec.getExtension("org.apache.tapestry.ognl-type-converter", class$ognl$TypeConverter == null ? (class$ognl$TypeConverter = ExpressionBinding.class$("ognl.TypeConverter")) : class$ognl$TypeConverter);
            Ognl.setTypeConverter((Map)this._context, (TypeConverter)typeConverter);
        }
        return this._context;
    }

    public boolean isInvariant() {
        this.initialize();
        return this._invariant;
    }

    public void setBoolean(boolean value) {
        this.setObject(value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setInt(int value) {
        this.setObject(new Integer(value));
    }

    public void setDouble(double value) {
        this.setObject(new Double(value));
    }

    public void setString(String value) {
        this.setObject(value);
    }

    private void initialize() {
        if (this._initialized) {
            return;
        }
        this._initialized = true;
        try {
            this._parsedExpression = OgnlUtils.getParsedExpression(this._expression);
        }
        catch (Exception ex) {
            throw new BindingException(ex.getMessage(), this, (Throwable)ex);
        }
        if (this.checkForConstant()) {
            return;
        }
        try {
            if (!Ognl.isSimpleNavigationChain((Object)this._parsedExpression, (Map)this.getOgnlContext())) {
                return;
            }
        }
        catch (OgnlException ex) {
            throw new BindingException(ex.getMessage(), this, (Throwable)ex);
        }
        String[] split = new StringSplitter('.').splitToArray(this._expression);
        int count = this.optimizeRootObject(split);
        if (count == split.length) {
            this._expression = null;
            this._parsedExpression = null;
            this._invariant = true;
            this._cachedValue = this._root;
            return;
        }
        this._expression = this.reassemble(count, split);
        this._parsedExpression = OgnlUtils.getParsedExpression(this._expression);
        this.checkForInvariant(count, split);
    }

    private int optimizeRootObject(String[] split) {
        int i;
        for (i = 0; i < split.length; ++i) {
            if (split[i].equals("page")) {
                this._root = this._root.getPage();
                continue;
            }
            if (split[i].equals("container")) {
                this._root = this._root.getContainer();
                continue;
            }
            if (!split[i].equals("components") || i + 1 >= split.length) break;
            this._root = this._root.getComponent(split[i + 1]);
            ++i;
        }
        return i;
    }

    private boolean checkForConstant() {
        try {
            if (Ognl.isConstant((Object)this._parsedExpression, (Map)this.getOgnlContext())) {
                this._invariant = true;
                this._cachedValue = this.resolveProperty();
                return true;
            }
        }
        catch (OgnlException ex) {
            throw new BindingException(Tapestry.format("ExpressionBinding.unable-to-resolve-expression", this._expression, this._root), this, (Throwable)ex);
        }
        return false;
    }

    private String reassemble(int start, String[] split) {
        int count = split.length - start;
        if (count == 0) {
            return null;
        }
        if (count == 1) {
            return split[split.length - 1];
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = start; i < split.length; ++i) {
            if (i > start) {
                buffer.append('.');
            }
            buffer.append(split[i]);
        }
        return buffer.toString();
    }

    private void checkForInvariant(int start, String[] split) {
        if (split.length - start != 2) {
            return;
        }
        try {
            if (!Ognl.isSimpleNavigationChain((Object)this._parsedExpression, (Map)this.getOgnlContext())) {
                return;
            }
        }
        catch (OgnlException ex) {
            throw new BindingException(Tapestry.format("ExpressionBinding.unable-to-resolve-expression", this._expression, this._root), this, (Throwable)ex);
        }
        String first = split[start];
        if (first.equals("listeners")) {
            this._invariant = true;
            this._cachedValue = this.resolveProperty();
            return;
        }
        if (first.equals("assets")) {
            String name = split[start + 1];
            this._invariant = true;
            this._cachedValue = this._root.getAsset(name);
            return;
        }
        if (first.equals("beans")) {
            String name = split[start + 1];
            IBeanSpecification bs = this._root.getSpecification().getBeanSpecification(name);
            if (bs == null || bs.getLifecycle() != BeanLifecycle.PAGE) {
                return;
            }
            this._invariant = true;
            this._cachedValue = this.resolveProperty();
            return;
        }
        if (first.equals("bindings")) {
            String name = split[start + 1];
            this._invariant = true;
            this._cachedValue = this._root.getBinding(name);
            return;
        }
    }

    public void setObject(Object value) {
        this.initialize();
        if (this._invariant) {
            throw this.createReadOnlyBindingException(this);
        }
        try {
            Ognl.setValue((Object)this._parsedExpression, (Map)this.getOgnlContext(), (Object)this._root, (Object)value);
        }
        catch (OgnlException ex) {
            throw new BindingException(Tapestry.format("ExpressionBinding.unable-to-update-expression", this._expression, this._root, value), this, (Throwable)ex);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ExpressionBinding[");
        buffer.append(this._root.getExtendedId());
        if (this._expression != null) {
            buffer.append(' ');
            buffer.append(this._expression);
        }
        if (this._invariant) {
            buffer.append(" cachedValue=");
            buffer.append(this._cachedValue);
        }
        buffer.append(']');
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

