/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.tapestry.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.tapestry.util.AccessaUtil;
import sun.misc.SoftCache;

public class CopyUtil {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$tapestry$util$CopyUtil == null ? (class$org$seasar$tapestry$util$CopyUtil = CopyUtil.class$("org.seasar.tapestry.util.CopyUtil")) : class$org$seasar$tapestry$util$CopyUtil));
    private static SetterCache setterCache = new SetterCache();
    private static GetterCache getterCache = new GetterCache();
    static /* synthetic */ Class class$org$seasar$tapestry$util$CopyUtil;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;

    public static void copy(Object object, Object object2, Object object3) {
        if (object == null || object2 == null || object3 == null) {
            return;
        }
        Map map = setterCache.getSetterMap(object.getClass());
        Map map2 = getterCache.getGetterMap(object2.getClass());
        CopyUtil.invokeGetterToSetter(object, object2, object3, map, map2);
    }

    public static void copyAll(Object object, Object object2) {
        if (object == null || object2 == null) {
            return;
        }
        Map map = setterCache.getSetterMap(object.getClass());
        Map map2 = getterCache.getGetterMap(object2.getClass());
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            CopyUtil.invokeGetterToSetter(object, object2, k, map, map2);
        }
    }

    public static void set(Object object, Object object2, Object object3) {
        if (object == null || object2 == null) {
            return;
        }
        Map map = setterCache.getSetterMap(object.getClass());
        CopyUtil.invokeToSetter(object, object2, object3, map);
    }

    public static void copyAllByPropertyName(Object object, Object object2) {
        CopyUtil.copyAllByKey(object, object2, class$java$lang$String == null ? (class$java$lang$String = CopyUtil.class$("java.lang.String")) : class$java$lang$String);
    }

    public static void copyAllByClass(Object object, Object object2) {
        CopyUtil.copyAllByKey(object, object2, class$java$lang$Class == null ? (class$java$lang$Class = CopyUtil.class$("java.lang.Class")) : class$java$lang$Class);
    }

    private static void copyAllByKey(Object object, Object object2, Class clazz) {
        if (object == null || object2 == null) {
            return;
        }
        Map map = setterCache.getSetterMap(object.getClass());
        Map map2 = getterCache.getGetterMap(object2.getClass());
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!k.getClass().equals(clazz)) continue;
            CopyUtil.invokeGetterToSetter(object, object2, k, map, map2);
        }
    }

    private static void invokeToSetter(Object object, Object object2, Object object3, Map map) {
        if (!map.containsKey(object2)) {
            return;
        }
        Method method = (Method)map.get(object2);
        CopyUtil.invoke(object, method, object3);
    }

    private static void invoke(Object object, Method method, Object object2) {
        try {
            method.invoke(object, object2);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("CopyUtil Invoke : TO " + method.getName() + "[" + object2 + "]"));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.info((Object)("CopyUtil Invoke Error : TO " + method.getName() + " Message " + illegalArgumentException.getMessage()));
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.info((Object)("CopyUtil Invoke Error : TO " + method.getName() + " Message " + illegalAccessException.getMessage()));
        }
        catch (InvocationTargetException invocationTargetException) {
            LOG.info((Object)("CopyUtil Invoke Error : TO " + method.getName() + " Message " + invocationTargetException.getMessage()));
        }
    }

    private static void invokeGetterToSetter(Object object, Object object2, Object object3, Map map, Map map2) {
        if (!map.containsKey(object3)) {
            return;
        }
        if (!map2.containsKey(object3)) {
            return;
        }
        Method method = (Method)map2.get(object3);
        Method method2 = (Method)map.get(object3);
        CopyUtil.invoke(object, object2, method2, method);
    }

    private static void invoke(Object object, Object object2, Method method, Method method2) {
        if (method2 == null || method == null) {
            return;
        }
        try {
            Object object3 = method2.invoke(object2, new Object[0]);
            method.invoke(object, object3);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("CopyUtil Invoke : " + method2.getName() + " TO " + method.getName() + "[" + object3 + "]"));
            }
        }
        catch (Exception exception) {
            LOG.info((Object)("CopyUtil Invoke Error : " + method2.getName() + " TO " + method.getName() + " Message " + exception.getMessage()));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class SetterCache {
        private Map destMethodCache = new SoftCache();

        SetterCache() {
        }

        public synchronized Map getSetterMap(Class clazz) {
            if (this.destMethodCache.containsKey(clazz)) {
                return (Map)this.destMethodCache.get(clazz);
            }
            Map map = this.makeSetterMap(clazz);
            this.cacheSetterMap(clazz, map);
            return map;
        }

        private Map makeSetterMap(Class clazz) {
            Method[] methodArray = clazz.getMethods();
            HashMap<Object, Method> hashMap = new HashMap<Object, Method>();
            for (int i = 0; i < methodArray.length; ++i) {
                Class clazz2;
                Method method = methodArray[i];
                if (!AccessaUtil.isSetterMethod(method) || (clazz2 = AccessaUtil.primitiveToWrapper(method.getParameterTypes()[0])) == null) continue;
                hashMap.put(clazz2, method);
                hashMap.put(AccessaUtil.getPropertyName(method), method);
            }
            return hashMap;
        }

        private void cacheSetterMap(Class clazz, Map map) {
            this.destMethodCache.put(clazz, map);
        }
    }

    static class GetterCache {
        private Map srcMethodCache = new SoftCache();

        GetterCache() {
        }

        public synchronized Map getGetterMap(Class clazz) {
            if (this.srcMethodCache.containsKey(clazz)) {
                return (Map)this.srcMethodCache.get(clazz);
            }
            Map map = this.makeGetterMap(clazz);
            this.cacheGetterMap(clazz, map);
            return map;
        }

        private void cacheGetterMap(Class clazz, Map map) {
            this.srcMethodCache.put(clazz, map);
        }

        private Map makeGetterMap(Class clazz) {
            Method[] methodArray = clazz.getMethods();
            HashMap<Object, Method> hashMap = new HashMap<Object, Method>();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                if (!AccessaUtil.isGetterMethod(method)) continue;
                Class clazz2 = AccessaUtil.primitiveToWrapper(method.getReturnType());
                hashMap.put(clazz2, method);
                hashMap.put(AccessaUtil.getPropertyName(method), method);
            }
            return hashMap;
        }
    }
}

