/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.tree.simple;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.tapestry.contrib.tree.model.IMutableTreeNode;
import org.apache.tapestry.contrib.tree.model.ITreeNode;

public class TreeNode
implements IMutableTreeNode {
    protected Set m_setChildren;
    protected IMutableTreeNode m_objParentNode;

    public TreeNode() {
        this(null);
    }

    public TreeNode(IMutableTreeNode parentNode) {
        this.m_objParentNode = parentNode;
        this.m_setChildren = new HashSet();
    }

    public int getChildCount() {
        return this.m_setChildren.size();
    }

    public ITreeNode getParent() {
        return this.m_objParentNode;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return this.m_setChildren.size() == 0;
    }

    public Collection children() {
        return this.m_setChildren;
    }

    public void insert(IMutableTreeNode child) {
        child.setParent(this);
        this.m_setChildren.add(child);
    }

    public void remove(IMutableTreeNode node) {
        this.m_setChildren.remove(node);
    }

    public void removeFromParent() {
        this.m_objParentNode.remove(this);
        this.m_objParentNode = null;
    }

    public void setParent(IMutableTreeNode newParent) {
        this.m_objParentNode = newParent;
    }

    public void insert(Collection colChildren) {
        Iterator iter = colChildren.iterator();
        while (iter.hasNext()) {
            IMutableTreeNode element = (IMutableTreeNode)iter.next();
            element.setParent(this);
            this.m_setChildren.add(element);
        }
    }

    public boolean containsChild(ITreeNode node) {
        return this.m_setChildren.contains(node);
    }

    public Collection getChildren() {
        return this.m_setChildren;
    }
}

