package org.seasar.jsf.selector;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.TagProcessor;
import org.seasar.jsf.TagSelector;
import org.seasar.jsf.processor.ElementProcessor;
import org.xml.sax.Attributes;

/**
 * @author higa
 *
 */
public class PassThroughElementSelector implements TagSelector {

	public PassThroughElementSelector() {
	}

	/**
	 * @see org.seasar.maya.pages.TagSelector#isSelectable(java.lang.String, java.lang.String, java.lang.String, org.xml.sax.Attributes)
	 */
	public boolean isSelectable(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		return "true".equalsIgnoreCase(attributes.getValue(JsfConstants.MAYA_NSURI, JsfConstants.PASSTHROUGH_ATTR));
	}

	public TagProcessor createProcessor() {
		return new ElementProcessor();
	}
	
	public String getInject() {
		return null;
	}

}
