/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.creditcardvalidator;

import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.util.MessageUtils;

public class CreditCardValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "org.apache.myfaces.validator.CreditCard";
    public static final String CREDITCARD_MESSAGE_ID = "org.apache.myfaces.Creditcard.INVALID";
    private static final boolean DEFAULT_AMEX = true;
    private static final boolean DEFAULT_DISCOVER = true;
    private static final boolean DEFAULT_MASTERCARD = true;
    private static final boolean DEFAULT_VISA = true;
    private static final boolean DEFAULT_NONE = false;
    private Boolean _amex = null;
    private Boolean _discover = null;
    private Boolean _mastercard = null;
    private Boolean _visa = null;
    private Boolean _none = null;
    private boolean _transient = false;
    private int _initSum = 0;
    private org.apache.commons.validator.CreditCardValidator creditCardValidator = null;

    public void validate(FacesContext facesContext, UIComponent uiComponent, Object value) throws ValidatorException {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return;
        }
        this.initValidator();
        if (!this.creditCardValidator.isValid(value.toString())) {
            Object[] args = new Object[]{value.toString()};
            throw new ValidatorException(MessageUtils.getMessage(FacesMessage.SEVERITY_ERROR, CREDITCARD_MESSAGE_ID, args));
        }
    }

    private void initValidator() {
        if (this.isNone()) {
            this.creditCardValidator = new org.apache.commons.validator.CreditCardValidator(0);
        } else {
            this.computeValidators();
            this.creditCardValidator = new org.apache.commons.validator.CreditCardValidator(this._initSum);
        }
    }

    private void computeValidators() {
        if (this.isAmex()) {
            this._initSum = 1 + this._initSum;
        }
        if (this.isVisa()) {
            this._initSum = 2 + this._initSum;
        }
        if (this.isMastercard()) {
            this._initSum = 4 + this._initSum;
        }
        if (this.isDiscover()) {
            this._initSum = 8 + this._initSum;
        }
    }

    public boolean isAmex() {
        if (this._amex != null) {
            return this._amex;
        }
        return this._amex != null ? this._amex : true;
    }

    public boolean isDiscover() {
        if (this._discover != null) {
            return this._discover;
        }
        return this._discover != null ? this._discover : true;
    }

    public boolean isMastercard() {
        if (this._mastercard != null) {
            return this._mastercard;
        }
        return this._mastercard != null ? this._mastercard : true;
    }

    public boolean isNone() {
        if (this._none != null) {
            return this._none;
        }
        return this._none != null ? this._none : false;
    }

    public boolean isVisa() {
        if (this._visa != null) {
            return this._visa;
        }
        return this._visa != null ? this._visa : true;
    }

    public void setAmex(boolean b) {
        this._amex = b;
    }

    public void setDiscover(boolean b) {
        this._discover = b;
    }

    public void setMastercard(boolean b) {
        this._mastercard = b;
    }

    public void setNone(boolean b) {
        this._none = b;
    }

    public void setVisa(boolean b) {
        this._visa = b;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[6];
        values[0] = this._amex;
        values[1] = this._discover;
        values[2] = this._mastercard;
        values[3] = this._visa;
        values[4] = this._none;
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this._amex = (Boolean)values[0];
        this._discover = (Boolean)values[1];
        this._mastercard = (Boolean)values[2];
        this._visa = (Boolean)values[3];
        this._none = (Boolean)values[4];
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean newTransientValue) {
        this._transient = newTransientValue;
    }
}

