/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.html.ext;

import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.ResultDataModel;
import javax.faces.model.ResultSetDataModel;
import javax.faces.model.ScalarDataModel;
import javax.servlet.jsp.jstl.sql.Result;

abstract class HtmlDataTableHack
extends HtmlDataTable {
    protected DataModel _dataModel = null;
    protected HashMap _dataModelMap = null;
    protected transient boolean _saveDescendantStates = false;
    private static final Class OBJECT_ARRAY_CLASS = new Object[0].getClass();
    private static final Integer INTEGER_MINUS1 = new Integer(-1);
    private int _rowIndex = -1;
    private Object[] _descendantStates;
    private int _descendantEditableValueHolderCount = -1;
    private Boolean _isEmbeddedUIData = null;
    private UIData _embeddingUIData = null;
    private static final DataModel EMPTY_DATA_MODEL = new DataModel(){

        public boolean isRowAvailable() {
            return false;
        }

        public int getRowCount() {
            return 0;
        }

        public Object getRowData() {
            throw new IllegalArgumentException();
        }

        public int getRowIndex() {
            return -1;
        }

        public void setRowIndex(int i) {
            if (i < -1) {
                throw new IllegalArgumentException();
            }
        }

        public Object getWrappedData() {
            return null;
        }

        public void setWrappedData(Object obj) {
            if (obj == null) {
                return;
            }
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }
    };

    HtmlDataTableHack() {
    }

    public boolean isRowAvailable() {
        return this.getDataModel().isRowAvailable();
    }

    public int getRowCount() {
        return this.getDataModel().getRowCount();
    }

    public Object getRowData() {
        return this.getDataModel().getRowData();
    }

    public int getRowIndex() {
        return this._rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.saveDescendantComponentStates();
        this._rowIndex = rowIndex;
        DataModel dataModel = this.getDataModel();
        dataModel.setRowIndex(rowIndex);
        String var = this.getVar();
        if (rowIndex == -1) {
            if (var != null) {
                this.getFacesContext().getExternalContext().getRequestMap().remove(var);
            }
        } else if (var != null) {
            if (this.isRowAvailable()) {
                Object rowData = dataModel.getRowData();
                this.getFacesContext().getExternalContext().getRequestMap().put(var, rowData);
            } else {
                this.getFacesContext().getExternalContext().getRequestMap().remove(var);
            }
        }
        this.restoreDescendantComponentStates();
    }

    private int getDescendantStatesRowIndex() {
        int rowIndex = this.getRowIndex();
        if (rowIndex == -1) {
            return 0;
        }
        return rowIndex - this.getFirst() + 1;
    }

    private void saveDescendantComponentStates() {
        if (this._descendantEditableValueHolderCount == -1) {
            this.refreshDescendantDataStates();
        } else {
            if (this._descendantEditableValueHolderCount == 0) {
                return;
            }
            int rowIndex = this.getDescendantStatesRowIndex();
            EditableValueHolderState[] rowState = null;
            if (rowIndex < this._descendantStates.length) {
                rowState = (EditableValueHolderState[])this._descendantStates[rowIndex];
            } else {
                this.refreshDescendantDataStates();
                rowState = (EditableValueHolderState[])this._descendantStates[rowIndex];
            }
            if (rowState == null) {
                this._descendantStates[rowIndex] = rowState = new EditableValueHolderState[this._descendantEditableValueHolderCount];
            }
            HtmlDataTableHack.saveDescendantComponentStates(this, rowState, 0, 0);
        }
    }

    private void refreshDescendantDataStates() {
        ArrayList list = new ArrayList();
        HtmlDataTableHack.saveDescendantComponentStates(this, list, 0);
        this._descendantEditableValueHolderCount = list.size();
        if (this._descendantEditableValueHolderCount > 0) {
            EditableValueHolderState[] rowState = list.toArray(new EditableValueHolderState[list.size()]);
            int rows = this.getRows();
            if (rows <= 0) {
                rows = this.getRowCount() - this.getFirst();
            }
            this._descendantStates = new Object[rows + 1];
            int rowIndex = this.getDescendantStatesRowIndex();
            this._descendantStates[rowIndex] = rowState;
        }
    }

    private static void saveDescendantComponentStates(UIComponent component, List list, int level) {
        Iterator it = HtmlDataTableHack.getChildrenAndOptionalFacetsIterator(level, component);
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (child instanceof EditableValueHolder) {
                list.add(new EditableValueHolderState((EditableValueHolder)((Object)child)));
            }
            HtmlDataTableHack.saveDescendantComponentStates(child, list, level + 1);
        }
    }

    private static int saveDescendantComponentStates(UIComponent component, EditableValueHolderState[] states, int counter, int level) {
        Iterator it = HtmlDataTableHack.getChildrenAndOptionalFacetsIterator(level, component);
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (child instanceof EditableValueHolder) {
                states[counter++] = new EditableValueHolderState((EditableValueHolder)((Object)child));
            }
            counter = HtmlDataTableHack.saveDescendantComponentStates(child, states, counter, level + 1);
        }
        return counter;
    }

    private void restoreDescendantComponentStates() {
        if (this._descendantEditableValueHolderCount == -1) {
            throw new IllegalStateException("saveDescendantComponentStates not called yet?");
        }
        if (this._descendantEditableValueHolderCount > 0) {
            int zeroBasedRowIdx = this.getDescendantStatesRowIndex();
            int stateRowsCount = this._descendantStates.length;
            EditableValueHolderState[] initialStates = null;
            if (stateRowsCount > 0) {
                initialStates = (EditableValueHolderState[])this._descendantStates[0];
            }
            if (zeroBasedRowIdx < stateRowsCount) {
                EditableValueHolderState[] rowState = (EditableValueHolderState[])this._descendantStates[zeroBasedRowIdx];
                HtmlDataTableHack.restoreDescendantComponentStates(this, rowState, initialStates, 0, 0);
            } else {
                HtmlDataTableHack.restoreDescendantComponentStates(this, initialStates, initialStates, 0, 0);
            }
        } else {
            HtmlDataTableHack.restoreDescendantComponentStates(this, null, null, 0, 0);
        }
    }

    private static int restoreDescendantComponentStates(UIComponent component, EditableValueHolderState[] states, EditableValueHolderState[] initialStates, int counter, int level) {
        Iterator it = HtmlDataTableHack.getChildrenAndOptionalFacetsIterator(level, component);
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            child.setId(child.getId());
            if (child instanceof EditableValueHolder) {
                if (states != null) {
                    states[counter].restore((EditableValueHolder)((Object)child));
                } else if (initialStates != null) {
                    initialStates[counter].restore((EditableValueHolder)((Object)child));
                } else {
                    ((EditableValueHolder)((Object)child)).setValue(null);
                    ((EditableValueHolder)((Object)child)).setLocalValueSet(false);
                    ((EditableValueHolder)((Object)child)).setValid(true);
                    ((EditableValueHolder)((Object)child)).setSubmittedValue(null);
                }
                ++counter;
            }
            counter = HtmlDataTableHack.restoreDescendantComponentStates(child, states, initialStates, counter, level + 1);
        }
        return counter;
    }

    private static Iterator getChildrenAndOptionalFacetsIterator(int level, UIComponent component) {
        Iterator it = null;
        it = level > 1 ? component.getFacetsAndChildren() : component.getChildren().iterator();
        return it;
    }

    public void setValueBinding(String name, ValueBinding binding) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.equals("value")) {
            this._dataModel = null;
        } else if (name.equals("var") || name.equals("rowIndex")) {
            throw new IllegalArgumentException("name " + name);
        }
        super.setValueBinding(name, binding);
    }

    private DataModel getDataModel() {
        UIData embeddingUIData = this.getEmbeddingUIData();
        if (embeddingUIData != null) {
            String embeddingClientId;
            DataModel dataModel;
            if (this._dataModelMap == null) {
                this._dataModelMap = new HashMap();
            }
            if ((dataModel = (DataModel)this._dataModelMap.get(embeddingClientId = embeddingUIData.getClientId(FacesContext.getCurrentInstance()))) == null) {
                dataModel = this.createDataModel();
                this._dataModelMap.put(embeddingClientId, dataModel);
            }
            return dataModel;
        }
        if (this._dataModel == null) {
            this._dataModel = this.createDataModel();
        }
        return this._dataModel;
    }

    private DataModel createDataModel() {
        Object value = this.getValue();
        if (value == null) {
            return EMPTY_DATA_MODEL;
        }
        if (value instanceof DataModel) {
            return (DataModel)value;
        }
        if (value instanceof List) {
            return new ListDataModel((List)value);
        }
        if (OBJECT_ARRAY_CLASS.isAssignableFrom(value.getClass())) {
            return new ArrayDataModel((Object[])value);
        }
        if (value instanceof ResultSet) {
            return new ResultSetDataModel((ResultSet)value);
        }
        if (value instanceof Result) {
            return new ResultDataModel((Result)value);
        }
        return new ScalarDataModel(value);
    }

    private UIData getEmbeddingUIData() {
        if (this._isEmbeddedUIData == null) {
            UIComponent findParentUIData;
            for (findParentUIData = this.getParent(); findParentUIData != null && !(findParentUIData instanceof UIData); findParentUIData = findParentUIData.getParent()) {
            }
            if (findParentUIData != null) {
                this._embeddingUIData = (UIData)findParentUIData;
                this._isEmbeddedUIData = Boolean.TRUE;
            } else {
                this._isEmbeddedUIData = Boolean.FALSE;
            }
        }
        if (this._isEmbeddedUIData.booleanValue()) {
            return this._embeddingUIData;
        }
        return null;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[7];
        values[0] = super.saveState(context);
        values[1] = this._saveDescendantStates ? this._descendantStates : null;
        values[2] = this._saveDescendantStates ? new Integer(this._descendantEditableValueHolderCount) : INTEGER_MINUS1;
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._descendantStates = (Object[])values[1];
        this._descendantEditableValueHolderCount = (Integer)values[2];
    }

    private static class EditableValueHolderState
    implements Serializable {
        private Object _localValue;
        private boolean _localValueSet;
        private boolean _valid;
        private Object _submittedValue;

        public EditableValueHolderState(EditableValueHolder vh) {
            this._localValue = vh.getLocalValue();
            this._localValueSet = vh.isLocalValueSet();
            this._valid = vh.isValid();
            this._submittedValue = vh.getSubmittedValue();
        }

        public void restore(EditableValueHolder vh) {
            vh.setValue(this._localValue);
            vh.setLocalValueSet(this._localValueSet);
            vh.setValid(this._valid);
            vh.setSubmittedValue(this._submittedValue);
        }
    }
}

