/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;

class _ComponentFacetMap
implements Map,
Serializable {
    private UIComponent _component;
    private Map _map = new HashMap();

    _ComponentFacetMap(UIComponent component) {
        this._component = component;
    }

    public int size() {
        return this._map.size();
    }

    public void clear() {
        this._map.clear();
    }

    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    public boolean containsKey(Object key) {
        this.checkKey(key);
        return this._map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        this.checkValue(value);
        return false;
    }

    public Collection values() {
        return this._map.values();
    }

    public void putAll(Map t) {
        Iterator it = t.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Set entrySet() {
        return this._map.entrySet();
    }

    public Set keySet() {
        return this._map.keySet();
    }

    public Object get(Object key) {
        this.checkKey(key);
        return this._map.get(key);
    }

    public Object remove(Object key) {
        this.checkKey(key);
        UIComponent facet = (UIComponent)this._map.remove(key);
        if (facet != null) {
            facet.setParent(null);
        }
        return facet;
    }

    public Object put(Object key, Object value) {
        this.checkKey(key);
        this.checkValue(value);
        this.setNewParent((String)key, (UIComponent)value);
        return this._map.put(key, value);
    }

    private void setNewParent(String facetName, UIComponent facet) {
        UIComponent oldParent = facet.getParent();
        if (oldParent != null) {
            oldParent.getFacets().remove(facetName);
        }
        facet.setParent(this._component);
    }

    private void checkKey(Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (!(key instanceof String)) {
            throw new ClassCastException("key is not a String");
        }
    }

    private void checkValue(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (!(value instanceof UIComponent)) {
            throw new ClassCastException("value is not a UIComponent");
        }
    }
}

