/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.log;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.message.MessageFormatter;

public final class Logger {
    private static Map loggerMap_ = Collections.synchronizedMap(new HashMap());
    private Log log_;

    private Logger(Class clazz) {
        this.log_ = LogFactory.getLog((Class)clazz);
    }

    public static final Logger getLogger(Class clazz) {
        Logger logger = (Logger)loggerMap_.get(clazz);
        if (logger == null) {
            logger = new Logger(clazz);
            loggerMap_.put(clazz, logger);
        }
        return logger;
    }

    public final boolean isDebugEnabled() {
        return this.log_.isDebugEnabled();
    }

    public final void debug(Object message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.log_.debug(message, throwable);
        }
    }

    public final void debug(Object message) {
        if (this.isDebugEnabled()) {
            this.log_.debug(message);
        }
    }

    public final boolean isInfoEnabled() {
        return this.log_.isInfoEnabled();
    }

    public final void info(Object message, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.log_.info(message, throwable);
        }
    }

    public final void info(Object message) {
        if (this.isInfoEnabled()) {
            this.log_.info(message);
        }
    }

    public final void warn(Object message, Throwable throwable) {
        this.log_.warn(message, throwable);
    }

    public final void warn(Object message) {
        this.log_.warn(message);
    }

    public final void error(Object message, Throwable throwable) {
        this.log_.error(message, throwable);
    }

    public final void error(Object message) {
        this.log_.error(message);
    }

    public final void fatal(Object message, Throwable throwable) {
        this.log_.fatal(message, throwable);
    }

    public final void fatal(Object message) {
        this.log_.fatal(message);
    }

    public final void log(Throwable throwable) {
        this.error(throwable.getMessage(), throwable);
    }

    public final void log(String messageCode, Object[] args) {
        this.log(messageCode, args, null);
    }

    public final void log(String messageCode, Object[] args, Throwable throwable) {
        char messageType = messageCode.charAt(0);
        if (this.isEnabledFor(messageType)) {
            String message = MessageFormatter.getSimpleMessage(messageCode, args);
            switch (messageType) {
                case 'D': {
                    this.log_.debug((Object)message, throwable);
                    break;
                }
                case 'I': {
                    this.log_.info((Object)message, throwable);
                    break;
                }
                case 'W': {
                    this.log_.warn((Object)message, throwable);
                    break;
                }
                case 'E': {
                    this.log_.error((Object)message, throwable);
                    break;
                }
                case 'F': {
                    this.log_.fatal((Object)message, throwable);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(messageType));
                }
            }
        }
    }

    private boolean isEnabledFor(char messageType) {
        switch (messageType) {
            case 'D': {
                return this.log_.isDebugEnabled();
            }
            case 'I': {
                return this.log_.isInfoEnabled();
            }
            case 'W': {
                return this.log_.isWarnEnabled();
            }
            case 'E': {
                return this.log_.isErrorEnabled();
            }
            case 'F': {
                return this.log_.isFatalEnabled();
            }
        }
        throw new IllegalArgumentException(String.valueOf(messageType));
    }
}

