/*
 *
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:
 *    "This product includes software developed by the
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission of
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.seasar.remoting.axis.deployer;

import javax.xml.namespace.QName;

import org.apache.axis.providers.java.JavaProvider;
import org.seasar.extension.unit.S2TestCase;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.MetaDef;
import org.seasar.remoting.axis.DeployFailedException;
import org.seasar.remoting.axis.deployment.WSDDS2Service;
import org.w3c.dom.Element;

/**
 * @author koichik
 */
public class ServiceDeployerTest extends S2TestCase {
    public ServiceDeployerTest(String name) {
        super(name);
    }

    public void testCreateWSDDS2Service() {
        include("ServiceDeployerTest.createWSDDS2Service.dicon");
        AxisDeployer deployer = new AxisDeployer();
        ServiceDeployer serviceDeployer = (ServiceDeployer) deployer.serviceDeployer;

        ComponentDef def1 = getComponentDef("null");
        MetaDef meta1 = def1.getMetaDef("s2-axis:service");
        WSDDS2Service service1 = serviceDeployer.createWSDDS2Service(def1, meta1);
        assertNotNull(service1);
        assertEquals(new QName("null"), service1.getQName());

        ComponentDef def2 = getComponentDef("serviceDef");
        MetaDef meta2 = def2.getMetaDef("s2-axis:service");
        WSDDS2Service service2 = serviceDeployer.createWSDDS2Service(def2, meta2);
        assertNotNull(service2);
        assertEquals(new QName("serviceDef"), service2.getQName());
        assertEquals("java.lang.Boolean", service2.getParameter(JavaProvider.OPTION_CLASSNAME));

        ComponentDef def3 = getComponentDef("wsdd");
        MetaDef meta3 = def3.getMetaDef("s2-axis:service");
        WSDDS2Service service3 = serviceDeployer.createWSDDS2Service(def3, meta3);
        assertNotNull(service3);
        assertEquals(new QName("FromWSDD"), service3.getQName());
        assertEquals("java.lang.Double", service3.getParameter(JavaProvider.OPTION_CLASSNAME));

        try {
            ComponentDef def4 = getComponentDef("int");
            MetaDef meta4 = def4.getMetaDef("s2-axis:service");
            serviceDeployer.createWSDDS2Service(def4, meta4);
            fail();
        }
        catch (DeployFailedException expected) {
        }
    }

    public void testGetServiceElement() {
        AxisDeployer deployer = new AxisDeployer();
        ServiceDeployer serviceDeployer = (ServiceDeployer) deployer.serviceDeployer;

        Element e1 = serviceDeployer
                .getServiceElement("org/seasar/remoting/axis/deployer/ServiceDeployerTest.getServiceElement1.wsdd");
        assertNotNull(e1);
        assertEquals("service", e1.getNodeName());
        assertEquals("one", e1.getAttribute("name"));

        try {
            serviceDeployer
                    .getServiceElement("org/seasar/remoting/axis/deployer/ServiceDeployerTest.getServiceElement0.wsdd");
            fail();
        }
        catch (DeployFailedException expected) {
        }

        try {
            serviceDeployer
                    .getServiceElement("org/seasar/remoting/axis/deployer/ServiceDeployerTest.getServiceElement2.wsdd");
            fail();
        }
        catch (DeployFailedException expected) {
        }
    }
}
