/*
 *
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:
 *    "This product includes software developed by the
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission of
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.seasar.remoting.axis.connector;

import java.lang.reflect.Method;
import java.net.URL;

import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.Service;
import javax.xml.rpc.encoding.TypeMapping;

import org.apache.axis.constants.Use;
import org.apache.axis.encoding.TypeMappingDelegate;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.seasar.remoting.axis.S2AxisConstants;
import org.seasar.remoting.common.connector.impl.TargetSpecificURLBasedConnector;

/**
 * WebT[rXĂяoS2RemotingRlN^̎NXłB
 * 
 * @author koichik
 */
public class AxisConnector extends TargetSpecificURLBasedConnector {
    //instance fields
    protected Service service;

    /**
     * AxisT[rXݒ肵܂B
     * 
     * @param service
     *            AxisT[rX
     */
    public void setService(final Service service) {
        this.service = service;

        final TypeMappingRegistry tmr = (TypeMappingRegistry) service.getTypeMappingRegistry();
        TypeMapping tm = tmr.getTypeMapping(Use.DEFAULT.getEncoding());
        ((TypeMappingDelegate) tm).setDoAutoTypes(true);
    }

    /**
     * AxisT[rXgpă[g\bȟĂяosǍʂԂ܂B
     * 
     * @param targetURL
     *            [gIuWFNgURL
     * @param method
     *            Ăяo\bh
     * @param args
     *            [gIuWFNg̃\bhĂяoɓnli[IuWFNgz
     * @return [gIuWFNgɑ΂郁\bhĂяo̖߂l
     * @throws Throwable
     *             [gIuWFNgɑ΂郁\bhĂяoX[O
     */
    protected Object invoke(final URL targetURL, final Method method, final Object[] args)
            throws Throwable {
        final Call call = service.createCall();
        call.setTargetEndpointAddress(targetURL.toString());
        call.setOperationName(new QName(S2AxisConstants.OPERATION_NAMESPACE_URI, method.getName()));
        return call.invoke(args);
    }
}
