/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.datalist;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.custom.datalist.HtmlDataList;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HTML;
import org.apache.myfaces.renderkit.html.HtmlRenderer;
import org.apache.myfaces.renderkit.html.HtmlRendererUtils;

public class HtmlListRenderer
extends HtmlRenderer {
    public static final String LAYOUT_SIMPLE = "simple";
    public static final String LAYOUT_UL = "unorderedList";
    public static final String LAYOUT_OL = "orderedList";
    static /* synthetic */ Class class$javax$faces$component$UIData;

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$javax$faces$component$UIData == null ? (class$javax$faces$component$UIData = HtmlListRenderer.class$("javax.faces.component.UIData")) : class$javax$faces$component$UIData);
        ResponseWriter writer = facesContext.getResponseWriter();
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        String layout = this.getLayout(uiComponent);
        if (layout != null) {
            if (layout.equals(LAYOUT_UL)) {
                writer.startElement("ul", uiComponent);
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            } else if (layout.equals(LAYOUT_OL)) {
                writer.startElement("ol", uiComponent);
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            } else if (uiComponent.getId() != null && !uiComponent.getId().startsWith("_id")) {
                writer.startElement("span", uiComponent);
                writer.writeAttribute("id", uiComponent.getClientId(facesContext), null);
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            } else {
                HtmlRendererUtils.renderHTMLAttributesWithOptionalStartElement(writer, uiComponent, "span", HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            }
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        int last;
        RendererUtils.checkParamValidity(facesContext, component, class$javax$faces$component$UIData == null ? (class$javax$faces$component$UIData = HtmlListRenderer.class$("javax.faces.component.UIData")) : class$javax$faces$component$UIData);
        UIData uiData = (UIData)component;
        String layout = this.getLayout(component);
        ResponseWriter writer = facesContext.getResponseWriter();
        int first = uiData.getFirst();
        int rows = uiData.getRows();
        int rowCount = uiData.getRowCount();
        if (rows <= 0) {
            rows = rowCount - first;
        }
        if ((last = first + rows) > rowCount) {
            last = rowCount;
        }
        for (int i = first; i < last; ++i) {
            uiData.setRowIndex(i);
            if (!uiData.isRowAvailable()) continue;
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            if (layout != null && (layout.equals(LAYOUT_UL) || layout.equals(LAYOUT_OL))) {
                writer.startElement("li", component);
            }
            RendererUtils.renderChildren(facesContext, component);
            if (layout == null || !layout.equals(LAYOUT_UL) && !layout.equals(LAYOUT_OL)) continue;
            writer.endElement("li");
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$javax$faces$component$UIData == null ? (class$javax$faces$component$UIData = HtmlListRenderer.class$("javax.faces.component.UIData")) : class$javax$faces$component$UIData);
        ResponseWriter writer = facesContext.getResponseWriter();
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        String layout = this.getLayout(uiComponent);
        if (layout != null) {
            if (layout.equals(LAYOUT_UL)) {
                writer.endElement("ul");
            } else if (layout.equals(LAYOUT_OL)) {
                writer.endElement("ol");
            } else if (uiComponent.getId() != null && !uiComponent.getId().startsWith("_id")) {
                writer.endElement("span");
            } else {
                HtmlRendererUtils.renderOptionalEndElement(writer, uiComponent, "span", HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            }
        }
    }

    private String getLayout(UIComponent component) {
        if (component instanceof HtmlDataList) {
            return ((HtmlDataList)component).getLayout();
        }
        return (String)component.getAttributes().get("layout");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

