package test.org.seasar.hibernate.dao.impl;

import java.util.List;

import org.seasar.extension.unit.S2TestCase;

import examples.hibernate.dao.EmployeeAutoDao;
import examples.hibernate.entity.Employee;

public class EmployeeDaoEmployeeDtoTest extends S2TestCase {

	private EmployeeAutoDao dao_;
	/**
	 * Constructor for S2SessionFactoryImplTest.
	 * @param arg0
	 */
	public EmployeeDaoEmployeeDtoTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(EmployeeDaoEmployeeDtoTest.class);
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();

		include("examples/hibernate/client/EmployeeAutoDao.dicon");
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}


	public void testGetEmployeeByDtoAuto_Empno(){
		Employee emp = new Employee();
		emp.setEmpno(new Integer(7369) );

		List ret = dao_.getEmployeeByEmployeeDtoAuto(emp);

		assertEquals(1,ret.size() );
		assertEquals("SMITH", ((Employee)ret.get(0) ).getEname()  );
	}
	
	public void testGetEmployeeByDtoAuto_Ename(){
		Employee emp = new Employee();
		emp.setEname("SMITH" );

		List ret = dao_.getEmployeeByEmployeeDtoAuto(emp);

		assertEquals(1,ret.size() );
		assertEquals( 7369 , ((Employee)ret.get(0) ).getEmpno().intValue()  );
	}
	

	
	public void testGetEmployeeByDtoAuto_JobAndDeptno(){
		Employee emp = new Employee();

		emp.setJob( "MANAGER"   );
		emp.setDeptno( new Integer(20)   );

		List ret = dao_.getEmployeeByEmployeeDtoAuto(emp);

		assertEquals(1,ret.size() );
		assertEquals("JONES", ((Employee)ret.get(0) ).getEname()  );
	}
	
	
	
	
}