package org.seasar.hibernate.dao.impl;

import java.util.HashMap;
import java.util.Map;

import org.seasar.hibernate.S2SessionFactory;
import org.seasar.hibernate.dao.HibernateDaoMetaData;
import org.seasar.hibernate.dao.HibernateDaoMetaDataFactory;

/**
 * @author kenichi_okazaki
 */
public class HibernateDaoMetaDataFactoryImpl implements
		HibernateDaoMetaDataFactory {

	private S2SessionFactory s2sessionFactory_;

	private Map daoMetaDataCache_ = new HashMap();

	public HibernateDaoMetaDataFactoryImpl(S2SessionFactory s2sessionFactory) {
		s2sessionFactory_ = s2sessionFactory;
	}

	public synchronized HibernateDaoMetaData getDaoMetaData(Class daoClass) {
		String key = daoClass.getName();
		HibernateDaoMetaData dmd = (HibernateDaoMetaData) daoMetaDataCache_
				.get(key);
		if (dmd != null) {
			return dmd;
		}
		dmd = new HibernateDaoMetaDataImpl(s2sessionFactory_, daoClass);
		daoMetaDataCache_.put(key, dmd);
		return dmd;
	}
}