/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.annotation;

import java.io.IOException;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.AnnotationsWriter;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.MemberValueVisitor;

public class StringMemberValue
extends MemberValue {
    int valueIndex;

    public StringMemberValue(int index, ConstPool cp) {
        super('s', cp);
        this.valueIndex = index;
    }

    public StringMemberValue(String str, ConstPool cp) {
        super('s', cp);
        this.setValue(str);
    }

    public StringMemberValue(ConstPool cp) {
        super('s', cp);
        this.setValue("");
    }

    public String getValue() {
        return this.cp.getUtf8Info(this.valueIndex);
    }

    public void setValue(String newValue) {
        this.valueIndex = this.cp.addUtf8Info(newValue);
    }

    public String toString() {
        return "\"" + this.getValue() + "\"";
    }

    void write(AnnotationsWriter writer) throws IOException {
        writer.constValueIndex(this.getValue());
    }

    public void accept(MemberValueVisitor visitor) {
        visitor.visitStringMemberValue(this);
    }
}

