/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.hibernate.impl;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import org.seasar.framework.util.ConnectionUtil;
import org.seasar.framework.util.DataSourceUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.TransactionManagerUtil;
import org.seasar.framework.util.TransactionUtil;
import org.seasar.hibernate.HibernateRuntimeException;
import org.seasar.hibernate.S2Session;
import org.seasar.hibernate.S2SessionFactory;
import org.seasar.hibernate.impl.S2SessionImpl;

public final class S2SessionFactoryImpl
implements S2SessionFactory,
Synchronization {
    private TransactionManager transactionManager_;
    private DataSource dataSource_;
    private String configPath_ = "hibernate.cfg.xml";
    private SessionFactory sessionFactory_;
    private Map txSessions_ = new HashMap();

    public S2SessionFactoryImpl(TransactionManager transactionManager, DataSource dataSource) {
        this.transactionManager_ = transactionManager;
        this.dataSource_ = dataSource;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager_;
    }

    public DataSource getDataSource() {
        return this.dataSource_;
    }

    public String getConfigPath() {
        return this.configPath_;
    }

    public void setConfigPath(String configPath) {
        this.configPath_ = configPath;
    }

    public synchronized SessionFactory getSessionFactory() {
        if (this.sessionFactory_ != null) {
            return this.sessionFactory_;
        }
        Configuration cfg = new Configuration();
        try {
            cfg.configure(ResourceUtil.getResource((String)this.configPath_));
            this.sessionFactory_ = cfg.buildSessionFactory();
        }
        catch (HibernateException ex) {
            throw new HibernateRuntimeException(ex);
        }
        return this.sessionFactory_;
    }

    public int getTxSessionSize() {
        return this.txSessions_.size();
    }

    public S2Session getSession() {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            return this.createSession();
        }
        S2Session session = (S2Session)this.txSessions_.get(tx);
        if (session != null && session.isOpen()) {
            return session;
        }
        return this.bindSession(tx);
    }

    private Transaction getTransaction() {
        return TransactionManagerUtil.getTransaction((TransactionManager)this.getTransactionManager());
    }

    private S2Session createSession() {
        SessionFactory factory = this.getSessionFactory();
        return new S2SessionImpl(factory.openSession(this.getConnection()));
    }

    private Connection getConnection() {
        return DataSourceUtil.getConnection((DataSource)this.getDataSource());
    }

    private S2Session bindSession(Transaction tx) {
        S2Session session = null;
        session = (S2Session)this.txSessions_.get(tx);
        if (session != null && session.isOpen()) {
            return session;
        }
        session = this.createSession();
        S2SessionFactoryImpl s2SessionFactoryImpl = this;
        synchronized (s2SessionFactoryImpl) {
            this.txSessions_.put(tx, session);
        }
        TransactionUtil.registerSynchronization((Transaction)tx, (Synchronization)this);
        return session;
    }

    public void beforeCompletion() {
        this.flushSession();
    }

    public void afterCompletion(int arg0) {
        this.closeSession();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeSession() {
        Connection con2;
        Transaction tx = this.getTransaction();
        if (tx == null) return;
        S2Session session = null;
        S2SessionFactoryImpl s2SessionFactoryImpl = this;
        synchronized (s2SessionFactoryImpl) {
            session = (S2Session)this.txSessions_.remove(tx);
        }
        if (session == null) return;
        if (!session.isOpen()) return;
        try {
            session.clear();
        }
        catch (Throwable throwable) {
            s2SessionFactoryImpl = null;
            Connection con2 = session.close();
            ConnectionUtil.close((Connection)con2);
            throw throwable;
        }
        {
            s2SessionFactoryImpl = null;
            con2 = session.close();
        }
        ConnectionUtil.close((Connection)con2);
    }

    private void flushSession() {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            S2Session session = null;
            session = (S2Session)this.txSessions_.get(tx);
            if (session != null && session.isOpen() && !session.isReadOnly()) {
                session.flush();
            }
        }
    }
}

