package test.org.seasar.framework.beans.impl;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Timestamp;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.IllegalPropertyRuntimeException;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.impl.BeanDescImpl;
import org.seasar.framework.util.MathUtil;

import junit.framework.TestCase;

/**
 * @author higa
 *
 */
public class PropertyDescImplTest extends TestCase {

	/**
	 * Constructor for BeanDescFactory.
	 * @param arg0
	 */
	public PropertyDescImplTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(PropertyDescImplTest.class);
	}
	
	public void testSetValue() throws Exception {
		MyBean myBean = new MyBean();
		BeanDesc beanDesc = new BeanDescImpl(MyBean.class);
		PropertyDesc propDesc = beanDesc.getPropertyDesc("fff");
		propDesc.setValue(myBean, new BigDecimal(2));
		assertEquals("1", 2, myBean.getFff());
	}
	
	public void testSetIllegalValue() throws Exception {
		MyBean myBean = new MyBean();
		BeanDesc beanDesc = new BeanDescImpl(MyBean.class);
		PropertyDesc propDesc = beanDesc.getPropertyDesc("fff");
		try {
			propDesc.setValue(myBean, "hoge");
			fail("1");
		} catch (IllegalPropertyRuntimeException ex) {
			System.out.println(ex);
		}
	}
	
	public void testSetBigDecimalValue() throws Exception {
		MyBean myBean = new MyBean();
		BeanDesc beanDesc = new BeanDescImpl(MyBean.class);
		PropertyDesc propDesc = beanDesc.getPropertyDesc("ggg");
		propDesc.setValue(myBean, new Integer(1));
		assertEquals("1", new BigDecimal(1), myBean.getGgg());
	}
	
	public void testSetTimestampValue() throws Exception {
		MyBean myBean = new MyBean();
		BeanDesc beanDesc = new BeanDescImpl(MyBean.class);
		PropertyDesc propDesc = beanDesc.getPropertyDesc("hhh");
		propDesc.setValue(myBean, "2000/11/8");
		assertNotNull("1", myBean.getHhh());
	}
	
	public void testConvertWithStringConstructor() throws Exception {
		MyBean myBean = new MyBean();
		BeanDesc beanDesc = new BeanDescImpl(MyBean.class);
		PropertyDesc propDesc = beanDesc.getPropertyDesc("URL");
		propDesc.setValue(myBean, "http://www.seasar.org");
		assertNotNull("1", myBean.getURL());
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}
	
	public static class MyBean {

		private int fff_;
		private BigDecimal ggg_;
		private Timestamp hhh_;
		private URL url_;
		
		public String getAaa() {
			return null;
		}

		public String getBbb(Object a) {
			return null;
		}

		public boolean isCCC() {
			return true;
		}

		public Object isDdd() {
			return null;
		}

		public String getEee() {
			return null;
		}

		public void setEee(String eee) {
		}
		
		public int getFff() {
			return fff_;
		}
		
		public void setFff(int fff) {
			fff_ = fff;
		}
		
		public Number add(Number arg1, Number arg2) {
			return MathUtil.add(arg1, arg2);
		}
		
		public BigDecimal getGgg() {
			return ggg_;
		}
		
		public void setGgg(BigDecimal ggg) {
			this.ggg_ = ggg;
		}
		
		public Timestamp getHhh() {
			return hhh_;
		}
		
		public void setHhh(Timestamp hhh) {
			this.hhh_ = hhh;
		}
		
		public URL getURL() {
			return url_;
		}
		
		public void setURL(URL url) {
			url_ = url;
		}
	}

}
