/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tree.renderkit.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.custom.tree.HtmlTree;
import org.apache.myfaces.custom.tree.HtmlTreeColumn;
import org.apache.myfaces.custom.tree.HtmlTreeImageCommandLink;
import org.apache.myfaces.custom.tree.HtmlTreeNode;
import org.apache.myfaces.custom.tree.IconProvider;
import org.apache.myfaces.custom.tree.TreeNode;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HTML;
import org.apache.myfaces.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.HtmlTableRendererBase;
import org.apache.myfaces.util.ArrayUtils;
import org.apache.myfaces.util.StringUtils;

public class HtmlTreeRenderer
extends HtmlTableRendererBase {
    private static final Integer ZERO = new Integer(0);
    private static final String DEFAULT_IMAGE_ICON_FOLDER = "images/folder.gif";
    static /* synthetic */ Class class$org$apache$myfaces$custom$tree$HtmlTree;

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component, class$org$apache$myfaces$custom$tree$HtmlTree == null ? (class$org$apache$myfaces$custom$tree$HtmlTree = HtmlTreeRenderer.class$("org.apache.myfaces.custom.tree.HtmlTree")) : class$org$apache$myfaces$custom$tree$HtmlTree);
        ResponseWriter writer = facesContext.getResponseWriter();
        HtmlTree tree = (HtmlTree)component;
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("table", null);
        HtmlRendererUtils.renderHTMLAttributes(writer, tree, HTML.TABLE_PASSTHROUGH_ATTRIBUTES);
        writer.writeAttribute("border", ZERO, null);
        writer.writeAttribute("cellspacing", ZERO, null);
        writer.writeAttribute("cellpadding", ZERO, null);
        int maxLevel = tree.getRootNode().getMaxChildLevel();
        ArrayList<HtmlTreeNode> childNodes = new ArrayList<HtmlTreeNode>(1);
        childNodes.add(tree.getRootNode());
        this.renderFacet(facesContext, writer, component, true, maxLevel);
        this.renderChildren(facesContext, writer, tree, childNodes, maxLevel, tree.getIconProvider());
        this.renderFacet(facesContext, writer, component, false, maxLevel);
        writer.endElement("table");
    }

    protected void renderFacet(FacesContext facesContext, ResponseWriter writer, UIComponent component, boolean header, int maxLevel) throws IOException {
        UIComponent facet;
        int colspan = 0;
        boolean hasColumnFacet = false;
        Iterator it = component.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent uiComponent = (UIComponent)it.next();
            if (uiComponent.getFamily().equals("javax.faces.Column") && ((UIColumn)uiComponent).isRendered()) {
                ++colspan;
                if (hasColumnFacet) continue;
                hasColumnFacet = header ? ((UIColumn)uiComponent).getHeader() != null : ((UIColumn)uiComponent).getFooter() != null;
                continue;
            }
            if (!uiComponent.getFamily().equals("org.apache.myfaces.HtmlTreeColumn") || !((HtmlTreeColumn)uiComponent).isRendered()) continue;
            colspan += maxLevel + 3;
            if (hasColumnFacet) continue;
            hasColumnFacet = header ? ((UIColumn)uiComponent).getHeader() != null : ((UIColumn)uiComponent).getFooter() != null;
        }
        UIComponent uIComponent = facet = header ? (UIComponent)component.getFacets().get("header") : (UIComponent)component.getFacets().get("footer");
        if (facet != null || hasColumnFacet) {
            String elemName = header ? "thead" : "tfoot";
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement(elemName, component);
            if (header) {
                String headerStyleClass = HtmlTreeRenderer.getHeaderClass(component);
                if (facet != null) {
                    this.renderTableHeaderRow(facesContext, writer, component, facet, headerStyleClass, colspan);
                }
                if (hasColumnFacet) {
                    this.renderColumnHeaderRow(facesContext, writer, component, headerStyleClass, maxLevel);
                }
            } else {
                String footerStyleClass = HtmlTreeRenderer.getFooterClass(component);
                if (hasColumnFacet) {
                    this.renderColumnFooterRow(facesContext, writer, component, footerStyleClass, maxLevel);
                }
                if (facet != null) {
                    this.renderTableFooterRow(facesContext, writer, component, facet, footerStyleClass, colspan);
                }
            }
            writer.endElement(elemName);
        }
    }

    protected void renderColumnHeaderRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, String headerStyleClass, int maxLevel) throws IOException {
        this.renderColumnHeaderOrFooterRow(facesContext, writer, component, headerStyleClass, true, maxLevel);
    }

    protected void renderColumnFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, String footerStyleClass, int maxLevel) throws IOException {
        this.renderColumnHeaderOrFooterRow(facesContext, writer, component, footerStyleClass, false, maxLevel);
    }

    private void renderColumnHeaderOrFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, String styleClass, boolean header, int maxLevel) throws IOException {
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tr", component);
        Iterator it = component.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent uiComponent = (UIComponent)it.next();
            if (uiComponent.getFamily().equals("javax.faces.Column") && ((UIColumn)uiComponent).isRendered()) {
                if (header) {
                    this.renderColumnHeaderCell(facesContext, writer, (UIColumn)uiComponent, styleClass, 0);
                    continue;
                }
                this.renderColumnFooterCell(facesContext, writer, (UIColumn)uiComponent, styleClass, 0);
                continue;
            }
            if (!uiComponent.getFamily().equals("org.apache.myfaces.HtmlTreeColumn") || !((HtmlTreeColumn)uiComponent).isRendered()) continue;
            if (header) {
                this.renderColumnHeaderCell(facesContext, writer, (UIColumn)uiComponent, styleClass, maxLevel + 3);
                continue;
            }
            this.renderColumnFooterCell(facesContext, writer, (UIColumn)uiComponent, styleClass, maxLevel + 3);
        }
        writer.endElement("tr");
    }

    protected void renderChildren(FacesContext facesContext, ResponseWriter writer, HtmlTree tree, List children, int maxLevel, IconProvider iconProvider) throws IOException {
        this.renderChildren(facesContext, writer, tree, children, maxLevel, iconProvider, 0);
    }

    protected void renderChildren(FacesContext facesContext, ResponseWriter writer, HtmlTree tree, List children, int maxLevel, IconProvider iconProvider, int rowClassIndex) throws IOException {
        String rowClasses = tree.getRowClasses();
        String columnClasses = tree.getColumnClasses();
        String[] rowClassesArray = rowClasses == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(rowClasses, ','));
        int rowClassesCount = rowClassesArray.length;
        String[] columnClassesArray = columnClasses == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(columnClasses, ','));
        int columnClassesCount = columnClassesArray.length;
        int columnClassIndex = 0;
        Iterator it = children.iterator();
        while (it.hasNext()) {
            List componentChildren;
            HtmlTreeNode child = (HtmlTreeNode)it.next();
            if (!child.isRendered()) continue;
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement("tr", null);
            if (rowClassIndex < rowClassesCount) {
                writer.writeAttribute("class", rowClassesArray[rowClassIndex], null);
            }
            if (rowClassesCount > 0) {
                ++rowClassIndex;
                rowClassIndex %= rowClassesCount;
            }
            if (null != tree.getVar()) {
                facesContext.getExternalContext().getSessionMap().put(tree.getVar(), ((TreeNode)child.getUserObject()).getUserObject());
            }
            if (null != (componentChildren = tree.getChildren()) && componentChildren.size() > 0) {
                int size = tree.getChildCount();
                for (int j = 0; j < size; ++j) {
                    UIComponent componentChild = (UIComponent)componentChildren.get(j);
                    if (componentChild.getFamily().equals("javax.faces.Column") && ((UIColumn)componentChild).isRendered()) {
                        writer.startElement("td", tree);
                        if (columnClassIndex < columnClassesCount) {
                            writer.writeAttribute("class", columnClassesArray[columnClassIndex], null);
                        }
                        if (columnClassesCount > 0) {
                            ++columnClassIndex;
                            columnClassIndex %= columnClassesCount;
                        }
                        RendererUtils.renderChild(facesContext, componentChild);
                        writer.endElement("td");
                        continue;
                    }
                    if (!componentChild.getFamily().equals("org.apache.myfaces.HtmlTreeColumn") || !((HtmlTreeColumn)componentChild).isRendered()) continue;
                    this.renderTreeColumnChild(facesContext, writer, componentChild, tree, child, maxLevel, iconProvider);
                }
            } else {
                this.renderTreeColumnChild(facesContext, writer, null, tree, child, maxLevel, iconProvider);
            }
            writer.endElement("tr");
            if (child.getChildCount() <= 0) continue;
            this.renderChildren(facesContext, writer, tree, child.getChildren(), maxLevel, iconProvider, rowClassIndex);
            if (rowClassesCount <= 0) continue;
            rowClassIndex += child.getChildCount() % rowClassesCount;
            rowClassIndex %= rowClassesCount;
        }
    }

    protected void renderTreeColumnChild(FacesContext facesContext, ResponseWriter writer, UIComponent component, HtmlTree tree, HtmlTreeNode child, int maxLevel, IconProvider iconProvider) throws IOException {
        String iconClass = tree.getIconClass();
        int[] layout = child.getLayout();
        for (int i = 0; i < layout.length - 1; ++i) {
            int state = layout[i];
            writer.startElement("td", null);
            String url = this.getLayoutImage(tree, state);
            if (url != null && url.length() > 0) {
                this.writeImageElement(url, facesContext, writer, child);
            }
            writer.endElement("td");
        }
        writer.startElement("td", null);
        int state = layout[layout.length - 1];
        String url = this.getLayoutImage(tree, state);
        if (state == 20 || state == 21 || state == 22) {
            this.writeImageElement(url, facesContext, writer, child);
        } else {
            HtmlTreeImageCommandLink expandCollapse = child.getExpandCollapseCommand(facesContext);
            expandCollapse.setImage(this.getLayoutImage(tree, layout[layout.length - 1]));
            expandCollapse.encodeBegin(facesContext);
            expandCollapse.encodeEnd(facesContext);
        }
        writer.endElement("td");
        int labelColSpan = maxLevel - child.getLevel() + 1;
        url = iconProvider != null ? iconProvider.getIconUrl(child.getUserObject(), child.getChildCount(), child.isLeaf(facesContext)) : (!child.isLeaf(facesContext) ? HtmlTree.getDefaultImagePath(DEFAULT_IMAGE_ICON_FOLDER) : null);
        if (url != null && url.length() > 0) {
            writer.startElement("td", null);
            if (iconClass != null) {
                writer.writeAttribute("class", iconClass, null);
            }
            this.writeImageElement(url, facesContext, writer, child);
            writer.endElement("td");
        } else {
            ++labelColSpan;
        }
        writer.startElement("td", null);
        writer.writeAttribute("colspan", new Integer(labelColSpan), null);
        if (child.isSelected() && tree.getSelectedNodeClass() != null) {
            writer.writeAttribute("class", tree.getSelectedNodeClass(), null);
        } else if (!child.isSelected() && tree.getNodeClass() != null) {
            writer.writeAttribute("class", tree.getNodeClass(), null);
        }
        List componentChildren = null;
        if (null != component) {
            componentChildren = component.getChildren();
        }
        if (null != componentChildren && componentChildren.size() > 0) {
            for (int k = 0; k < componentChildren.size(); ++k) {
                UIComponent componentChild = (UIComponent)componentChildren.get(k);
                RendererUtils.renderChild(facesContext, componentChild);
            }
        } else {
            child.encodeBegin(facesContext);
            child.encodeEnd(facesContext);
        }
        writer.endElement("td");
    }

    private void writeImageElement(String url, FacesContext facesContext, ResponseWriter writer, HtmlTreeNode child) throws IOException {
        writer.startElement("img", child);
        String src = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, url);
        writer.writeAttribute("src", src, null);
        writer.writeAttribute("border", ZERO, null);
        HtmlRendererUtils.renderHTMLAttributes(writer, child, HTML.IMG_PASSTHROUGH_ATTRIBUTES);
        writer.endElement("img");
    }

    protected String getLayoutImage(HtmlTree tree, int state) {
        switch (state) {
            case 0: {
                return tree.getIconNodeOpenMiddle();
            }
            case 1: {
                return tree.getIconNodeOpenFirst();
            }
            case 2: {
                return tree.getIconNodeOpenLast();
            }
            case 3: {
                return tree.getIconNodeOpen();
            }
            case 10: {
                return tree.getIconNodeCloseMiddle();
            }
            case 11: {
                return tree.getIconNodeCloseFirst();
            }
            case 12: {
                return tree.getIconNodeCloseLast();
            }
            case 13: {
                return tree.getIconNodeClose();
            }
            case 20: {
                return tree.getIconChildMiddle();
            }
            case 21: {
                return tree.getIconChildFirst();
            }
            case 22: {
                return tree.getIconChildLast();
            }
            case 30: {
                return tree.getIconLine();
            }
            case 40: {
                return tree.getIconNoline();
            }
        }
        return tree.getIconNoline();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

