/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dataset.states;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.seasar.extension.dataset.DataColumn;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.states.AbstractRowState;

public class ModifiedState
extends AbstractRowState {
    private static Map sqlCache_ = Collections.synchronizedMap(new WeakHashMap());

    public String toString() {
        return "MODIFIED";
    }

    protected String getSql(DataTable table) {
        String sql = (String)sqlCache_.get(table);
        if (sql == null) {
            sql = ModifiedState.createSql(table);
            sqlCache_.put(table, sql);
        }
        return sql;
    }

    private static String createSql(DataTable table) {
        DataColumn column;
        StringBuffer buf = new StringBuffer(100);
        buf.append("UPDATE ");
        buf.append(table.getTableName());
        buf.append(" SET ");
        int i = 0;
        while (i < table.getColumnSize()) {
            column = table.getColumn(i);
            if (column.isWritable() && !column.isPrimaryKey()) {
                buf.append(column.getColumnName());
                buf.append(" = ?, ");
            }
            ++i;
        }
        buf.setLength(buf.length() - 2);
        buf.append(" WHERE ");
        i = 0;
        while (i < table.getColumnSize()) {
            column = table.getColumn(i);
            if (column.isPrimaryKey()) {
                buf.append(column.getColumnName());
                buf.append(" = ? AND ");
            }
            ++i;
        }
        buf.setLength(buf.length() - 5);
        return buf.toString();
    }

    protected Object[] getArgs(DataRow row) {
        DataColumn column;
        DataTable table = row.getTable();
        ArrayList<Object> bindVariables = new ArrayList<Object>();
        int i = 0;
        while (i < table.getColumnSize()) {
            column = table.getColumn(i);
            if (column.isWritable() && !column.isPrimaryKey()) {
                bindVariables.add(row.getValue(i));
            }
            ++i;
        }
        i = 0;
        while (i < table.getColumnSize()) {
            column = table.getColumn(i);
            if (column.isPrimaryKey()) {
                bindVariables.add(row.getValue(i));
            }
            ++i;
        }
        return bindVariables.toArray();
    }
}

