/*
 *
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:
 *    "This product includes software developed by the
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission of
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.seasar.remoting.common.interceptor;

import java.lang.reflect.Method;

import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.remoting.common.connector.Connector;

/**
 * [gIuWFNg̃\bhĂяos߂̃C^[Zv^łB
 * <p>
 * ̃C^[Zv^JavaC^tF[X܂͒ۃNXɓKpAĂяoꂽ\bh^[QbgɂĎĂȂꍇ(ۃ\bh)
 * {@link Connector}ɈϏ邱Ƃɂ胊[gIuWFNg̃\bhĂяos܂B
 * <p>
 * C^[Zv^̓^[Qbg̃R|[lg`疼O( <code>&lt;component&gt;</code> vf
 * <code>name</code> ̒l)擾A̖O[gIuWFNg̖OƂ {@link Connector#invoke}
 * Ăяo܂BR|[lg`ɖO`ĂȂꍇ́AR|[lǧ^( <code>&lt;component&gt;</code>
 * vf <code>class</code> ̒l)pbP[WO[gIuWFNg̖OƂ܂B
 * R|[lǧ^`ĂȂꍇ́A^[QbgIuWFNg̃NXpbP[WO[gIuWFNg̖OƂ܂B
 * vpeB <code>remoteName</code>
 * (IvV)ݒ肳Ă΁A̒lɃ[gIuWFNg̖OƂĎgp܂B
 * 
 * @see Connector
 * @author koichik
 */
public class RemotingInterceptor extends AbstractInterceptor {
    protected Connector connector;
    protected String remoteName;

    /**
     * [gĂяos {@link Connector}ݒ肵܂B̃vpeB͕K{łB
     * 
     * @param connector
     *            [gĂяos {@link Connector}
     */
    public void setConnector(final Connector connector) {
        this.connector = connector;
    }

    /**
     * [gIuWFNg̖Oݒ肵܂B̃vpeB̓IvVłB
     * R|[lg`擾ł閼OgƂoȂꍇɂ̂ݐݒ肵ĂB
     * 
     * @param remoteName
     *            [gIuWFNg̖O
     */
    public void setRemoteName(final String remoteName) {
        this.remoteName = remoteName;
    }

    /**
     * ^[Qbg̃\bhNꂽɌĂяo܂BNꂽ\bhۃ\bhȂ {@link Connector}ɈϏ܂B
     * ۃ\bhȂ^[Qbg̃\bhĂяo܂B
     * 
     * @param invocation
     *            \bh̋N
     */
    public Object invoke(final MethodInvocation invocation) throws Throwable {
        final Method method = invocation.getMethod();
        if (MethodUtil.isAbstract(method)) {
            return connector.invoke(getRemoteName(invocation), method, invocation.getArguments());
        }
        return invocation.proceed();
    }

    /**
     * [gIuWFNg̖OԂ܂B[gIuWFNg̖Ȍ͎ŉ܂B
     * <ul>
     * <li>vpeB <code>remoteName</code> ݒ肳Ă΂̒lB</li>
     * <li>R|[lg`ɖOݒ肳Ă΂̒lB</li>
     * <li>R|[lg`Ɍ^ݒ肳Ă΂̖OpbP[WlB</li>
     * <li>^[QbgIuWFNǧ^pbP[WlB</li>
     * </ul>
     * 
     * @param invocation
     *            \bh̋N
     * @return [gIuWFNg̖O
     */
    protected String getRemoteName(final MethodInvocation invocation) {
        if (remoteName != null) {
            return remoteName;
        }

        final ComponentDef componentDef = getComponentDef(invocation);
        final String componentName = componentDef.getComponentName();
        if (componentName != null) {
            return componentName;
        }

        final Class componentClass = componentDef.getComponentClass();
        if (componentClass != null) {
            return ClassUtil.getShortClassName(componentClass);
        }

        return ClassUtil.getShortClassName(invocation.getThis().getClass());
    }
}