/*
 *
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:
 *    "This product includes software developed by the
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission of
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.seasar.remoting.common.connector.impl;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * ^[QbgƂȂIuWFNgƂɌʂURLgpă[g\bhĂяosRlN^̒ۊNXłB
 * <p>
 * ̃RlN^̓[gIuWFNg̖OX[p[NX̃vpeBɐݒ肳ꂽx[XURL̑URLƂă^[QbgƂȂ郊[gIuWFNgURL܂B
 * ̂߁Cx[XURLXbV( <code>/</code> )ŏIĂȂꍇA\ȂʂɂȂ邩ȂƂɒӂĂB
 * <p>
 * ܂B <br>
 * x[XURL̂悤ɐݒ肳ĂƂ܂B
 * 
 * <pre>
 *  http://host/context/services/
 * </pre>
 * 
 * [gIuWFNg̖OłƂ܂B
 * 
 * <pre>
 *  Foo
 * </pre>
 * 
 * [gIuWFNgURL͎̂悤ɂȂ܂B
 * 
 * <pre>
 *  http://host/context/services/Foo
 * </pre>
 * 
 * x[XURL̂悤ɃXbV( <code>/</code> )ŏIĂȂꍇ͌ʂقȂ܂B
 * 
 * <pre>
 *  http://host/context/services
 * </pre>
 * 
 * [gIuWFNg̖OłƂ܂B
 * 
 * <pre>
 *  Foo
 * </pre>
 * 
 * [gIuWFNgURL͎̂悤ɂȂ܂B
 * 
 * <pre>
 *  http://host/context/Foo
 * </pre>
 * 
 * @author koichik
 */
public abstract class TargetSpecificURLBasedConnector extends URLBasedConnector {
    /**
     * [gIuWFNgURLLbṼftHgl
     */
    protected static final int DEFAULT_MAX_CACHED_URLS = 10;

    protected LRUMap cachedURLs = new LRUMap(DEFAULT_MAX_CACHED_URLS);

    /**
     * [gIuWFNgURLLbVݒ肵܂B
     * 
     * @param maxCachedURLs
     *            [gIuWFNgURLLbVł
     */
    public synchronized void setMaxCachedURLs(final int maxCachedURLs) {
        cachedURLs.setMaxSize(maxCachedURLs);
    }

    /**
     * ^[QbgƂȂ郊[gIuWFNgURLATuNXŗL̕@Ń\bhĂяos܂B
     * 
     * @param remoteName
     *            [gIuWFNg̖O
     * @param method
     *            Ăяo\bh
     * @param args
     *            [gIuWFNg̃\bhĂяoɓnli[IuWFNgz
     * @return [gIuWFNgɑ΂郁\bhĂяo̖߂l
     * @throws Throwable
     *             [gIuWFNgɑ΂郁\bhĂяoX[ꂽOł
     */
    public Object invoke(final String remoteName, final Method method, final Object[] args)
            throws Throwable {
        return invoke(getTargetURL(remoteName), method, args);
    }

    /**
     * ^[QbgƂȂ郊[gIuWFNgURLԂ܂B
     * [gIuWFNgURĹA[gIuWFNg̖Ox[XURL̑URLƂĉ܂B
     * 
     * @param remoteName
     *            ^[QbgƂȂ郊[gIuWFNg̖O
     * @return ^[QbgƂȂ郊[gIuWFNgURL
     * @throws MalformedURLException
     *             x[XURLƃ[gIuWFNg̖OURL쐬łȂꍇɃX[܂
     */
    protected synchronized URL getTargetURL(final String remoteName) throws MalformedURLException {
        URL targetURL = (URL) cachedURLs.get(remoteName);
        if (targetURL == null) {
            targetURL = new URL(baseURL, remoteName);
            cachedURLs.put(remoteName, targetURL);
        }
        return targetURL;
    }

    /**
     * TuNXŗL̕@Ń[g\bȟĂяosǍʂԂ܂B
     * 
     * @param targetURL
     *            ^[QbgƂȂ郊[gIuWFNgURL
     * @param method
     *            Ăяo\bh
     * @param args
     *            [gIuWFNg̃\bhĂяoɓnli[IuWFNgz
     * @return [gIuWFNgɑ΂郁\bhĂяo̖߂l
     * @throws Throwable
     *             [gIuWFNgɑ΂郁\bhĂяoX[ꂽOł
     */
    protected abstract Object invoke(URL targetURL, Method method, Object[] args) throws Throwable;

    /**
     * LRU}bv <br>
     * GgɏA𒴂ăGgǉꂽꍇɂ͂ƂgpĂȂGg菜}bv̎łB
     * Gg̏͐₷Ƃo܂A炵Ă̐܂ŃGg菜邱Ƃ͂܂B ̃}bv͓܂B
     * 
     * @author koichik
     */
    protected static class LRUMap extends LinkedHashMap {
        /** ftHge */
        protected static final int DEFAULT_INITIAL_CAPACITY = 16;
        /** ftHg׌W */
        protected static final float DEFAULT_LOAD_FACTOR = 0.75f;

        protected int maxSize;

        /**
         * ftHg̏eʂƕ׌WŎw肳ꂽGgƂCX^X\z܂B
         * 
         * @param maxSize
         *            Gg̍ő吔
         */
        public LRUMap(final int maxSize) {
            this(maxSize, DEFAULT_INITIAL_CAPACITY, DEFAULT_LOAD_FACTOR);
        }

        /**
         * w肳ꂽeʂƕ׌WAGg̏CX^X\z܂B
         * 
         * @param maxSize
         *            Gg̍ő吔
         * @param initialCapacity
         *            e
         * @param loadFactor
         *            ׌W
         */
        public LRUMap(final int maxSize, final int initialCapacity, final float loadFactor) {
            super(initialCapacity, loadFactor, true);
            this.maxSize = maxSize;
        }

        /**
         * Gg̍őlݒ肵܂B
         * 
         * @param maxSize
         *            Gg̍ő吔
         */
        public void setMaxSize(final int maxSize) {
            this.maxSize = maxSize;
        }

        /**
         * }bṽGgő吔𒴂Ăꍇ <code>true</code> Ԃ܂B
         * ̌ʁAłOɃ}bvɑ}ꂽGg}bv폜܂B
         * 
         * @param eldest
         *            ƂOɃ}bvɑ}ꂽGg
         * @return }bṽGgő吔𒴂Ăꍇ <code>true</code>
         */
        protected boolean removeEldestEntry(final Map.Entry eldest) {
            return maxSize > 0 && size() > maxSize;
        }
    }
}