/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.runtime;

import java.util.Stack;
import org.seasar.jsf.JsfConfig;
import org.seasar.jsf.TagProcessor;
import org.seasar.jsf.TagSelector;
import org.seasar.jsf.ViewTemplateFactory;
import org.seasar.jsf.processor.TextProcessor;
import org.seasar.jsf.processor.ViewProcessor;
import org.seasar.jsf.runtime.TagSelectors;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TagProcessorHandler
extends DefaultHandler {
    private TagSelectors tagSelectors;
    private JsfConfig jsfConfig;
    private ViewTemplateFactory viewTemplateFactory;
    private Stack processorStack = new Stack();
    private TagProcessor root;

    public TagProcessorHandler(TagSelectors tagSelectors, JsfConfig jsfConfig, ViewTemplateFactory viewTemplateFactory) {
        this.tagSelectors = tagSelectors;
        this.jsfConfig = jsfConfig;
        this.viewTemplateFactory = viewTemplateFactory;
    }

    public TagProcessor getRoot() {
        return this.root;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
        TagSelector selector = this.tagSelectors.getTagSelector(namespaceURI, localName, qName, attributes);
        TagProcessor processor = null;
        if (selector != null) {
            processor = selector.createProcessor();
        }
        if (!this.processorStack.isEmpty()) {
            TagProcessor parentProcessor = this.peekProcessor();
            if (parentProcessor != null) {
                parentProcessor.addChild(processor);
            }
        } else {
            this.root = new ViewProcessor(this.jsfConfig, this.viewTemplateFactory);
            this.root.addChild(processor);
        }
        processor.setup(namespaceURI, localName, qName, attributes, this.jsfConfig);
        this.processorStack.push(processor);
    }

    protected TagProcessor peekProcessor() {
        return (TagProcessor)this.processorStack.peek();
    }

    protected TagProcessor popProcessor() {
        return (TagProcessor)this.processorStack.pop();
    }

    public void characters(char[] buffer, int start, int length) {
        if (!this.processorStack.isEmpty()) {
            String content = new String(buffer, start, length);
            TagProcessor processor = this.peekProcessor();
            if (processor == null) {
                return;
            }
            processor.addChild(new TextProcessor(content));
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        this.popProcessor();
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public void warning(SAXParseException e) throws SAXException {
        System.err.println(e);
    }
}

