package org.seasar.jsf.taglib.html;

import javax.faces.component.UIComponent;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.component.html.HtmlLink;
import org.seasar.jsf.taglib.UIComponentTagBase;

public class HtmlLinkTag extends UIComponentTagBase {

	private String rel;
	
	private String type;
	
	private String href;
	
	private String media;
	
	public void setRel(String rel) {
		this.rel = rel;
	}
	
	public void setType(String type) {
		this.type = type;
	}
	
	public void setHref(String href) {
		this.href = href;
	}
	
	public void setMedia(String media) {
		this.media = media;
	}
	
	public String getComponentType() {
		return HtmlLink.COMPONENT_TYPE;
	}

	public String getRendererType() {
		return HtmlLink.DEFAULT_RENDERER_TYPE;
	}
	
	protected void setProperties(UIComponent component) {
		super.setProperties(component);
		setComponentProperty(component, JsfConstants.REL_ATTR, rel);
		setComponentProperty(component, JsfConstants.TYPE_ATTR, type);
		setComponentProperty(component, JsfConstants.HREF_ATTR, href);
		setComponentProperty(component, JsfConstants.MEDIA_ATTR, media);
	}
	
	public void release() {
		super.release();
		rel = null;
		type = null;
		href = null;
		media = null;
	}
}