package org.seasar.jsf.runtime;

import java.io.File;

import org.seasar.jsf.TagProcessor;
import org.seasar.jsf.ViewTemplate;

/**
 * @author higa
 *  
 */
public class ViewTemplateImpl implements ViewTemplate {

	private TagProcessor rootTagProcessor;

	private File file;

	private long lastModified;

	public ViewTemplateImpl(TagProcessor rootTagProcessor) {
		this(rootTagProcessor, null);
	}

	public ViewTemplateImpl(TagProcessor rootTagProcessor, File file) {
		this.rootTagProcessor = rootTagProcessor;
		if (file != null) {
			this.file = file;
			this.lastModified = file.lastModified();
		}
	}

	public TagProcessor getRootTagProcessor() {
		return rootTagProcessor;
	}
	
	public long getLastModified() {
		return file.lastModified();
	}

	public boolean isModified() {
		if (file != null) {
			return getLastModified() > lastModified;
		} else {
			return false;
		}
	}
}