package org.seasar.framework.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import org.seasar.framework.exception.ParseRuntimeException;

public final class DateConversionUtil {

	private DateConversionUtil() {
	}

	public static Date toDate(Object o) {
		return toDate(o, null);
	}
	
	public static Date toDate(Object o, String pattern) {
		if (o == null) {
			return null;
		} else if (o instanceof String) {
			return toDate((String) o, pattern);
		} else if (o instanceof Date) {
			return (Date) o;
		} else if (o instanceof Calendar) {
			return ((Calendar) o).getTime();
		} else {
			return toDate(o.toString(), pattern);
		}
	}
	
	public static Date toDate(String s, String pattern) {
		SimpleDateFormat sdf = getDateFormat(s, pattern);
		try {
			return sdf.parse(s);
		} catch (ParseException ex) {
			throw new ParseRuntimeException(ex);
		}
	}
	
	public static SimpleDateFormat getDateFormat(String s, String pattern) {
		if (pattern != null) {
			return new SimpleDateFormat(pattern);
		} else {
			return getDateFormat(s);
		}
	}
	
	public static SimpleDateFormat getDateFormat(String s) {
		String pattern = getPattern();
		String shortPattern = removeDelimiter(pattern);
		String delimitor = findDelimiter(s);
		if (delimitor == null) {
			if (s.length() == shortPattern.length()) {
				return new SimpleDateFormat(shortPattern);
			}
			if (s.length() == shortPattern.length() + 2) {
				return new SimpleDateFormat(StringUtil.replace(shortPattern, "yy", "yyyy"));
			}
		} else {
			String[] array = StringUtil.split(s, delimitor);
			for (int i = 0; i < array.length; ++i) {
				if (array[i].length() == 4) {
					pattern = StringUtil.replace(pattern, "yy", "yyyy");
					break;
				}
			}
			return new SimpleDateFormat(pattern);
		}
		return new SimpleDateFormat();
	}
	
	public static SimpleDateFormat getDateFormat() {
		return new SimpleDateFormat(getPattern());
	}
	
	public static SimpleDateFormat getY4DateFormat() {
		return new SimpleDateFormat(getY4Pattern());
	}
	
	public static String getY4Pattern() {
		String pattern = getPattern();
		if (pattern.indexOf("yyyy") < 0) {
			pattern = StringUtil.replace(pattern, "yy", "yyyy");
		}
		return pattern;
	}
	public static String getPattern() {
		SimpleDateFormat df = (SimpleDateFormat) DateFormat.getDateInstance(DateFormat.SHORT);
		String pattern = df.toPattern();
		int index = pattern.indexOf(' ');
		if (index > 0) {
			pattern = pattern.substring(0, index);
		}
		if (pattern.indexOf("MM") < 0) {
			pattern = StringUtil.replace(pattern, "M", "MM");
		}
		if (pattern.indexOf("dd") < 0) {
			pattern = StringUtil.replace(pattern, "d", "dd");
		}
		return pattern;
	}
	
	public static String findDelimiter(String value) {
		for (int i = 0; i < value.length(); ++i) {
			char c = value.charAt(i);
			if (Character.isDigit(c)) {
				continue;
			}
			return Character.toString(c);
		}
		return null;
	}
	
	public static String removeDelimiter(String pattern) {
		StringBuffer buf = new StringBuffer();
		for (int i = 0; i < pattern.length(); ++i) {
			char c = pattern.charAt(i);
			if (c == 'y' || c == 'M' || c == 'd') {
				buf.append(c);
			}
		}
		return buf.toString();
	}
}
