package org.seasar.jsf.taglib;

import javax.faces.component.UIComponent;

import org.seasar.jsf.component.UIInsert;

/**
 * @author higa
 *  
 */
public class UIInsertTag extends UIComponentTagBase {

	private String name;
	
	private String src;

	public UIInsertTag() {
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	public String getSrc() {
		return src;
	}

	public void setSrc(String src) {
		this.src = src;
	}

	public String getComponentType() {
		return UIInsert.COMPONENT_TYPE;
	}

	public String getRendererType() {
		return null;
	}

	/**
	 * @see javax.faces.webapp.UIComponentTag#setProperties(javax.faces.component.UIComponent)
	 */
	protected void setProperties(UIComponent component) {
		super.setProperties(component);
		UIInsert insert = (UIInsert) component;
		insert.setName(name);
		insert.setSrc(src);
	}

	/**
	 * @see javax.servlet.jsp.tagext.Tag#release()
	 */
	public void release() {
		super.release();
		name = null;
		src = null;
	}
}