package org.seasar.jsf.taglib;

import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;

import org.seasar.jsf.JsfConstants;

public class SelectItemTag extends UIComponentTagBase {

	private String itemDescription;

	private String itemDisabled;

	private String itemLabel;

	private String itemValue;

	public void setItemDescription(String itemDescription) {
		this.itemDescription = itemDescription;
	}

	public void setItemDisabled(String itemDisabled) {
		this.itemDisabled = itemDisabled;
	}

	public void setItemLabel(String itemLabel) {
		this.itemLabel = itemLabel;
	}

	public void setItemValue(String itemValue) {
		this.itemValue = itemValue;
	}

	public String getComponentType() {
		return UISelectItem.COMPONENT_TYPE;
	}

	public String getRendererType() {
		return null;
	}

	public void release() {
		super.release();
		itemDescription = null;
		itemDisabled = null;
		itemLabel = null;
		itemValue = null;
	}

	protected void setProperties(UIComponent component) {
		super.setProperties(component);
		setComponentProperty(component, JsfConstants.ITEM_DESCRIPTION_ATTR,
				itemDescription);
		setComponentProperty(component, JsfConstants.ITEM_DISABLED_ATTR,
				itemDisabled);
		setComponentProperty(component, JsfConstants.ITEM_LABEL_ATTR, itemLabel);
		setComponentProperty(component, JsfConstants.ITEM_VALUE_ATTR, itemValue);
	}
}