package org.seasar.jsf.selector;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.TagProcessor;
import org.seasar.jsf.processor.SelectItemProcessor;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class SelectItemSelector extends AbstractTagSelector {

	private static final String TAG_NAME = "selectItem";
	
	public SelectItemSelector() {
	}

	public boolean isSelectable(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		if (JsfConstants.OPTION_ELEM.equalsIgnoreCase(qName)) {
			return true;
		}
		String inject = attributes.getValue(JsfConstants.MAYA_NSURI, JsfConstants.INJECT_ATTR);
		if (inject == null) {
			return false;
		}
		return getInject().equalsIgnoreCase(inject);
	}

	public TagProcessor createProcessor() {
		return new SelectItemProcessor(getInject());
	}
	
	public String getInject() {
		return getS2JsfInject(TAG_NAME);
	}
}