package org.seasar.jsf.selector;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.TagProcessor;
import org.seasar.jsf.processor.InsertProcessor;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class InsertSelector extends AbstractTagSelector {

	private static final String TAG_NAME = "insert";
	
	public InsertSelector() {
	}

	public boolean isSelectable(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		String inject = attributes.getValue(JsfConstants.MAYA_NSURI, JsfConstants.INJECT_ATTR);
		if (inject == null) {
			return false;
		}
		return getInject().equalsIgnoreCase(inject);
	}

	public TagProcessor createProcessor() {
		return new InsertProcessor(getInject());
	}
	
	public String getInject() {
		return getS2JsfInject(TAG_NAME);
	}
}