package org.seasar.jsf.component.html;

import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

/**
 * @author higa
 *  
 */
public class HtmlTitle extends UIComponentBase {

	public static final String COMPONENT_TYPE = "org.seasar.jsf.Title";

	public static final String COMPONENT_FAMILY = "javax.faces.Output";
	
	public static final String DEFAULT_RENDERER_TYPE = "org.seasar.jsf.Title";

	private Object value;

	public HtmlTitle() {
		setRendererType(DEFAULT_RENDERER_TYPE);
	}

	public Object getValue() {
		if (value != null) {
			return value;
		}
        ValueBinding vb = getValueBinding("value");
        return vb != null ? vb.getValue(getFacesContext()) : null;
	}
	
	public void setValue(Object value) {
		this.value = value;
	}
	
	/**
	 * @see javax.faces.component.UIComponent#getFamily()
	 */
	public String getFamily() {
		return COMPONENT_FAMILY;
	}
	
	public Object saveState(FacesContext context) {
		Object[] values = new Object[2];
		values[0] = super.saveState(context);
		values[1] = value;
		return values;
	}

	public void restoreState(FacesContext context, Object state) {
		Object values[] = (Object[]) state;
		super.restoreState(context, values[0]);
		value = values[1];
	}
}