/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.processor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import org.seasar.jsf.JsfConfig;
import org.seasar.jsf.JsfContext;
import org.seasar.jsf.TagProcessor;
import org.seasar.jsf.ViewTemplate;
import org.seasar.jsf.ViewTemplateFactory;
import org.seasar.jsf.exception.InsertProcessorNotFoundRuntimeException;
import org.seasar.jsf.processor.ElementProcessor;
import org.seasar.jsf.processor.InsertProcessor;
import org.seasar.jsf.processor.TagProcessorImpl;
import org.seasar.jsf.util.BindingUtil;

public class ViewProcessor
extends TagProcessorImpl {
    private static final String TAG = "view";
    private String contentType;
    private String encoding;
    private String extendsPath;
    private String initAction;
    private List insertProcessors = new ArrayList();
    private ViewTemplateFactory viewTemplateFactory;

    public ViewProcessor() {
    }

    public ViewProcessor(JsfConfig jsfConfig, ViewTemplateFactory viewTemplateFactory) {
        this.setProperty("inject", String.valueOf(jsfConfig.getTaglibPrefix("http://java.sun.com/jsf/core")) + ":" + TAG);
        this.processInject(jsfConfig);
        this.viewTemplateFactory = viewTemplateFactory;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
        int index = contentType.indexOf("charset");
        if (index < 0) {
            throw new IllegalArgumentException("charset not found in " + contentType);
        }
        int index2 = contentType.indexOf("=", index + 1);
        this.encoding = contentType.substring(index2 + 1);
        this.encoding = this.encoding.trim();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public InsertProcessor getInsertProcessor(String name) {
        int i = 0;
        while (i < this.insertProcessors.size()) {
            InsertProcessor ip = (InsertProcessor)this.insertProcessors.get(i);
            if (name == null && ip.getName() == null || name != null && name.equalsIgnoreCase(ip.getName())) {
                return ip;
            }
            ++i;
        }
        throw new InsertProcessorNotFoundRuntimeException(name);
    }

    public void addInsertProcessor(InsertProcessor insertProcessor) {
        this.insertProcessors.add(insertProcessor);
    }

    public String[] getIncludes() {
        HashSet includes = new HashSet();
        this.addIncludes(includes);
        return includes.toArray(new String[includes.size()]);
    }

    protected void addIncludes(Set includes) {
        int i = 0;
        while (i < this.insertProcessors.size()) {
            InsertProcessor ip = (InsertProcessor)this.insertProcessors.get(i);
            String src = ip.getSrc();
            if (src != null) {
                includes.add(src);
            }
            ++i;
        }
        ViewProcessor extendsViewProcessor = this.getExtendsViewProcessor();
        if (extendsViewProcessor != null) {
            extendsViewProcessor.addIncludes(includes);
        }
    }

    public String getExtendsPath() {
        return this.extendsPath;
    }

    public void setExtendsPath(String extendsPath) {
        this.extendsPath = extendsPath;
    }

    protected ViewProcessor getExtendsViewProcessor() {
        if (this.extendsPath == null) {
            return null;
        }
        ViewTemplate vt = this.viewTemplateFactory.getViewTemplate(this.extendsPath);
        return (ViewProcessor)vt.getRootTagProcessor();
    }

    public String getInitAction() {
        return this.initAction;
    }

    public void setInitAction(String initAction) {
        this.initAction = initAction;
    }

    public void process(JsfContext jsfContext, Tag parentTag) throws JspException {
        this.setupParams(jsfContext.getJsfConfig(), jsfContext.getPageContext().getRequest());
        ViewProcessor extendsViewProcessor = this.getExtendsViewProcessor();
        if (extendsViewProcessor != null) {
            this.setupInsertProcessorMap(jsfContext.getPageContext());
            extendsViewProcessor.process(jsfContext, parentTag);
        } else {
            super.process(jsfContext, parentTag);
        }
    }

    protected void setupInsertProcessorMap(PageContext pageContext) {
        Map insertProcessorMap = this.getInsertProcessorMap(pageContext);
        int i = 0;
        while (i < this.insertProcessors.size()) {
            InsertProcessor ip = (InsertProcessor)this.insertProcessors.get(i);
            String name = ip.getName();
            if (name != null && !insertProcessorMap.containsKey(name)) {
                insertProcessorMap.put(name, ip);
            }
            ++i;
        }
    }

    protected void setupParams(JsfConfig jsfConfig, ServletRequest request) {
        FacesContext context = FacesContext.getCurrentInstance();
        Application app = context.getApplication();
        String inject = String.valueOf(jsfConfig.getTaglibPrefix("http://java.sun.com/jsf/core")) + ":param";
        TagProcessor bodyProcessor = this.findBodyProcessor(this);
        if (bodyProcessor == null) {
            return;
        }
        int i = 0;
        while (i < bodyProcessor.getChildCount()) {
            String name;
            TagProcessor tp = bodyProcessor.getChild(i);
            if (inject.equalsIgnoreCase(tp.getProperty("inject")) && request.getAttribute(name = tp.getProperty("name")) == null) {
                String valstr = tp.getProperty("value");
                Object value = valstr;
                if (BindingUtil.isValueReference(valstr)) {
                    ValueBinding vb = app.createValueBinding(valstr);
                    value = vb.getValue(context);
                }
                request.setAttribute(name, value);
            }
            ++i;
        }
    }

    protected TagProcessor findBodyProcessor(TagProcessor tp) {
        int i = 0;
        while (i < tp.getChildCount()) {
            ElementProcessor ep;
            TagProcessor child = tp.getChild(i);
            if (child instanceof ElementProcessor && "body".equalsIgnoreCase((ep = (ElementProcessor)child).getTagName())) {
                return child;
            }
            TagProcessor bp = this.findBodyProcessor(child);
            if (bp != null) {
                return bp;
            }
            ++i;
        }
        return null;
    }
}

