/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.ext;

import java.io.IOException;
import java.text.MessageFormat;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.component.html.ext.HtmlMessage;
import org.apache.myfaces.component.html.ext.HtmlMessages;
import org.apache.myfaces.renderkit.html.HtmlMessagesRendererBase;
import org.apache.myfaces.renderkit.html.ext.HtmlMessageRenderer;

public class HtmlMessagesRenderer
extends HtmlMessagesRendererBase {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeEnd(facesContext, component);
        this.renderMessages(facesContext, component);
    }

    protected String getSummary(FacesContext facesContext, UIComponent message, FacesMessage facesMessage, String msgClientId) {
        String summaryFormat;
        String msgSummary = facesMessage.getSummary();
        if (msgSummary == null) {
            return null;
        }
        if (msgClientId == null) {
            summaryFormat = this.getGlobalSummaryFormat(message);
            if (summaryFormat == null) {
                summaryFormat = this.getSummaryFormat(message);
            }
        } else {
            summaryFormat = this.getSummaryFormat(message);
        }
        if (summaryFormat == null) {
            return msgSummary;
        }
        String inputLabel = null;
        if (msgClientId != null) {
            inputLabel = HtmlMessageRenderer.findInputLabel(facesContext, msgClientId);
        }
        if (inputLabel == null) {
            inputLabel = "";
        }
        MessageFormat format = new MessageFormat(summaryFormat, facesContext.getViewRoot().getLocale());
        return format.format(new Object[]{msgSummary, inputLabel});
    }

    private String getSummaryFormat(UIComponent message) {
        if (message instanceof HtmlMessages) {
            return ((HtmlMessages)message).getSummaryFormat();
        }
        return (String)message.getAttributes().get("summaryFormat");
    }

    private String getGlobalSummaryFormat(UIComponent message) {
        if (message instanceof HtmlMessages) {
            return ((HtmlMessages)message).getGlobalSummaryFormat();
        }
        return (String)message.getAttributes().get("globalSummaryFormat");
    }

    protected String getDetail(FacesContext facesContext, UIComponent message, FacesMessage facesMessage, String msgClientId) {
        String msgDetail = facesMessage.getDetail();
        if (msgDetail == null) {
            return null;
        }
        String detailFormat = message instanceof HtmlMessage ? ((HtmlMessage)message).getDetailFormat() : (String)message.getAttributes().get("detailFormat");
        if (detailFormat == null) {
            return msgDetail;
        }
        String inputLabel = null;
        if (msgClientId != null) {
            inputLabel = HtmlMessageRenderer.findInputLabel(facesContext, msgClientId);
        }
        if (inputLabel == null) {
            inputLabel = "";
        }
        MessageFormat format = new MessageFormat(detailFormat, facesContext.getViewRoot().getLocale());
        return format.format(new Object[]{msgDetail, inputLabel});
    }
}

