/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.util.BinaryTree;
import org.apache.poi.util.LittleEndian;

class SSTDeserializer {
    private BinaryTree strings;
    private int continuationReadChars;
    private String unfinishedString;
    private boolean wideChar;
    private boolean richText;
    private boolean extendedText;
    private short runCount;
    private int charCount;
    private int extensionLength;
    private int continueSkipBytes = 0;

    public SSTDeserializer(BinaryTree strings) {
        this.strings = strings;
        this.initVars();
    }

    private void initVars() {
        this.runCount = 0;
        this.continuationReadChars = 0;
        this.unfinishedString = "";
        this.wideChar = false;
        this.richText = false;
        this.extendedText = false;
        this.continueSkipBytes = 0;
    }

    public void manufactureStrings(byte[] data, int initialOffset) {
        this.initVars();
        int dataSize = data.length;
        for (int offset = initialOffset; offset < dataSize; offset += this.totalStringSize()) {
            boolean stringContinuesOverContinuation;
            int remaining = dataSize - offset;
            if (remaining > 0 && remaining < 2) {
                throw new RecordFormatException("Cannot get length of the last string in SSTRecord");
            }
            if (remaining == 2) {
                this.setContinuationCharsRead(0);
                this.unfinishedString = "";
                break;
            }
            int charsRead = this.charCount = LittleEndian.getUShort(data, offset);
            this.readStringHeader(data, offset);
            boolean bl = stringContinuesOverContinuation = remaining < this.totalStringSize();
            if (stringContinuesOverContinuation) {
                int remainingBytes = dataSize - offset - this.stringHeaderOverhead();
                charsRead = Math.min(charsRead, this.calculateCharCount(remainingBytes));
                this.setContinuationCharsRead(charsRead);
                if (charsRead == this.charCount) {
                    this.continueSkipBytes = this.offsetForContinuedRecord(0) - (remainingBytes - this.calculateByteCount(charsRead));
                }
            }
            this.processString(data, offset, charsRead);
            if (!stringContinuesOverContinuation) continue;
            break;
        }
    }

    private void readStringHeader(byte[] data, int index) {
        byte optionFlag = data[index + 2];
        this.wideChar = (optionFlag & 1) == 1;
        this.extendedText = (optionFlag & 4) == 4;
        this.richText = (optionFlag & 8) == 8;
        this.runCount = 0;
        if (this.richText) {
            this.runCount = LittleEndian.getShort(data, index + 3);
        }
        this.extensionLength = 0;
        if (this.extendedText) {
            this.extensionLength = LittleEndian.getInt(data, index + 3 + (this.richText ? 2 : 0));
        }
    }

    private int processString(byte[] data, int dataIndex, int characters) {
        int length = 3 + this.calculateByteCount(characters);
        byte[] unicodeStringBuffer = new byte[length];
        int offset = 0;
        LittleEndian.putUShort(unicodeStringBuffer, offset, characters);
        unicodeStringBuffer[offset += 2] = data[dataIndex + offset];
        int bytesRead = unicodeStringBuffer.length - 3;
        this.arraycopy(data, dataIndex + this.stringHeaderOverhead(), unicodeStringBuffer, 3, bytesRead);
        UnicodeString string = new UnicodeString(4095, (short)unicodeStringBuffer.length, unicodeStringBuffer);
        this.setContinuationCharsRead(this.calculateCharCount(bytesRead));
        if (this.isStringFinished()) {
            Integer integer = new Integer(this.strings.size());
            SSTDeserializer.addToStringTable(this.strings, integer, string);
        } else {
            this.unfinishedString = string.getString();
        }
        return bytesRead;
    }

    private boolean isStringFinished() {
        return this.getContinuationCharsRead() == this.charCount;
    }

    public static void addToStringTable(BinaryTree strings, Integer integer, UnicodeString string) {
        if (string.isRichText()) {
            string.setOptionFlags((byte)(string.getOptionFlags() & 0xFFFFFFF7));
        }
        if (string.isExtendedText()) {
            string.setOptionFlags((byte)(string.getOptionFlags() & 0xFFFFFFFB));
        }
        boolean added = false;
        while (!added) {
            try {
                strings.put(integer, string);
                added = true;
            }
            catch (Exception ignore) {
                string.setString(string.getString() + " ");
            }
        }
    }

    private int calculateCharCount(int byte_count) {
        return byte_count / (this.wideChar ? 2 : 1);
    }

    public void processContinueRecord(byte[] record) {
        if (this.isStringFinished()) {
            int offset = this.continueSkipBytes;
            this.initVars();
            this.manufactureStrings(record, offset);
        } else {
            boolean bl = this.wideChar = (record[0] & 1) == 1;
            if (this.stringSpansContinuation(record.length - 1)) {
                this.processEntireContinuation(record);
            } else {
                this.readStringRemainder(record);
            }
        }
    }

    private void readStringRemainder(byte[] record) {
        int stringRemainderSizeInBytes = this.calculateByteCount(this.charCount - this.getContinuationCharsRead());
        byte[] unicodeStringData = new byte[3 + stringRemainderSizeInBytes];
        LittleEndian.putShort(unicodeStringData, 0, (short)(this.charCount - this.getContinuationCharsRead()));
        unicodeStringData[2] = this.createOptionByte(this.wideChar, this.richText, this.extendedText);
        this.arraycopy(record, 1, unicodeStringData, 3, stringRemainderSizeInBytes);
        UnicodeString string = new UnicodeString(4095, (short)unicodeStringData.length, unicodeStringData, this.unfinishedString);
        Integer integer = new Integer(this.strings.size());
        SSTDeserializer.addToStringTable(this.strings, integer, string);
        int newOffset = this.offsetForContinuedRecord(stringRemainderSizeInBytes);
        this.manufactureStrings(record, newOffset);
    }

    private int stringSizeInBytes() {
        return this.calculateByteCount(this.charCount);
    }

    private int totalStringSize() {
        return this.stringSizeInBytes() + this.stringHeaderOverhead() + 4 * this.runCount + this.extensionLength;
    }

    private int stringHeaderOverhead() {
        return 3 + (this.richText ? 2 : 0) + (this.extendedText ? 4 : 0);
    }

    private int offsetForContinuedRecord(int stringRemainderSizeInBytes) {
        int offset = stringRemainderSizeInBytes + this.runCount * 4 + this.extensionLength;
        if (stringRemainderSizeInBytes != 0) {
            ++offset;
        }
        return offset;
    }

    private byte createOptionByte(boolean wideChar, boolean richText, boolean farEast) {
        return (byte)((wideChar ? 1 : 0) + (farEast ? 4 : 0) + (richText ? 8 : 0));
    }

    private void processEntireContinuation(byte[] record) {
        int dataLengthInBytes = record.length - 1;
        byte[] unicodeStringData = new byte[record.length + 2];
        int charsRead = this.calculateCharCount(dataLengthInBytes);
        LittleEndian.putShort(unicodeStringData, 0, (short)charsRead);
        this.arraycopy(record, 0, unicodeStringData, 2, record.length);
        UnicodeString ucs = new UnicodeString(4095, (short)unicodeStringData.length, unicodeStringData, this.unfinishedString);
        this.unfinishedString = ucs.getString();
        this.setContinuationCharsRead(this.getContinuationCharsRead() + charsRead);
        if (this.getContinuationCharsRead() == this.charCount) {
            Integer integer = new Integer(this.strings.size());
            SSTDeserializer.addToStringTable(this.strings, integer, ucs);
        }
    }

    private boolean stringSpansContinuation(int continuationSizeInBytes) {
        return this.calculateByteCount(this.charCount - this.getContinuationCharsRead()) > continuationSizeInBytes;
    }

    int getContinuationCharsRead() {
        return this.continuationReadChars;
    }

    private void setContinuationCharsRead(int count) {
        this.continuationReadChars = count;
    }

    private int calculateByteCount(int character_count) {
        return character_count * (this.wideChar ? 2 : 1);
    }

    private void arraycopy(byte[] src, int src_position, byte[] dst, int dst_position, int length) {
        System.arraycopy(src, src_position, dst, dst_position, length);
    }

    String getUnfinishedString() {
        return this.unfinishedString;
    }

    boolean isWideChar() {
        return this.wideChar;
    }
}

