package org.seasar.jsf.selector;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.TagProcessor;
import org.seasar.jsf.processor.TagProcessorImpl;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class BaseSelector extends AbstractTagSelector {

	private static final String TAG_NAME = "base";
	
	public BaseSelector() {
	}

	public boolean isSelectable(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		return JsfConstants.BASE_ELEM.equalsIgnoreCase(qName);
	}

	public TagProcessor createProcessor() {
		return new TagProcessorImpl(getInject());
	}
	
	public String getInject() {
		return getS2JsfInject(TAG_NAME);
	}
}