/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.runtime;

import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.seasar.framework.util.JarFileUtil;
import org.seasar.framework.util.JarURLConnectionUtil;
import org.seasar.framework.util.URLUtil;
import org.seasar.jsf.TaglibConfig;
import org.seasar.jsf.TaglibManager;
import org.seasar.jsf.exception.UriNotFoundRuntimeException;
import org.seasar.jsf.runtime.TaglibConfigBuilder;

public abstract class AbstractTaglibManager
implements TaglibManager {
    protected static final String FILE_PROTOCOL = "file:";
    protected static final String JAR_PROTOCOL = "jar:";
    protected static final String JAR_PROTOCOL_SUFFIX = "!/";
    protected static final String JAR_FILE_SUFFIX = ".jar";
    private Map taglibConfigs = new HashMap();
    private TaglibConfigBuilder builder = new TaglibConfigBuilder();

    public TaglibConfig getTaglibConfig(String uri) throws UriNotFoundRuntimeException {
        TaglibConfig taglibConfig = (TaglibConfig)this.taglibConfigs.get(uri);
        if (taglibConfig == null) {
            throw new UriNotFoundRuntimeException(uri);
        }
        return taglibConfig;
    }

    public boolean hasTaglibConfig(String uri) {
        return this.taglibConfigs.containsKey(uri);
    }

    public void destroy() {
        this.taglibConfigs.clear();
    }

    protected JarURLConnection openJarURLConnection(URL url) {
        URLConnection conn = URLUtil.openConnection((URL)url);
        if (conn instanceof JarURLConnection) {
            return (JarURLConnection)conn;
        }
        String urlStr = url.toString();
        if (urlStr.startsWith(FILE_PROTOCOL) && urlStr.endsWith(JAR_FILE_SUFFIX)) {
            URL jarURL = URLUtil.create((String)(JAR_PROTOCOL + urlStr + JAR_PROTOCOL_SUFFIX));
            return (JarURLConnection)URLUtil.openConnection((URL)jarURL);
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void scanJar(JarURLConnection conn) {
        conn.setUseCaches(false);
        JarFile jarFile = JarURLConnectionUtil.getJarFile((JarURLConnection)conn);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            Throwable ignore2;
            Object var7_7;
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith("META-INF/") || !name.endsWith(".tld")) continue;
            InputStream is = JarFileUtil.getInputStream((JarFile)jarFile, (ZipEntry)entry);
            try {
                this.scanTld(is);
            }
            catch (Throwable throwable) {
                var7_7 = null;
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (Throwable ignore2) {
                    // empty catch block
                }
                throw throwable;
            }
            {
                var7_7 = null;
                if (is == null) continue;
            }
            try {}
            catch (Throwable ignore2) {
                // empty catch block
                continue;
            }
            is.close();
            continue;
            break;
        }
        return;
    }

    protected void scanTld(InputStream is) {
        TaglibConfig taglibConfig = this.builder.build(is);
        this.taglibConfigs.put(taglibConfig.getUri(), taglibConfig);
    }
}

