/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.application;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;
import org.seasar.framework.util.ClassUtil;
import org.seasar.jsf.application.TreeStructure;

public class S2StateManager
extends StateManager
implements Serializable {
    static final long serialVersionUID = 0L;
    private static final String SERIALIZED_VIEW_ATTR;
    private RenderKitFactory renderKitFactory;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.jsf.application.S2StateManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SERIALIZED_VIEW_ATTR = String.valueOf(clazz.getName()) + ".SERIALIZED_VIEW";
    }

    public StateManager.SerializedView saveSerializedView(FacesContext context) throws IllegalStateException {
        ExternalContext externalContext = context.getExternalContext();
        Object struct = this.getTreeStructureToSave(context);
        Object state = this.getComponentStateToSave(context);
        StateManager.SerializedView serializedView = new StateManager.SerializedView((StateManager)this, struct, state);
        if (this.isSavingStateInClient(context)) {
            return serializedView;
        }
        this.saveSerializedViewToSession(externalContext, context.getViewRoot().getViewId(), serializedView);
        return null;
    }

    protected StateManager.SerializedView getSerializedViewFromSession(ExternalContext externalContext, String viewId) {
        return (StateManager.SerializedView)externalContext.getSessionMap().get(String.valueOf(SERIALIZED_VIEW_ATTR) + "-" + viewId);
    }

    protected void saveSerializedViewToSession(ExternalContext externalContext, String viewId, StateManager.SerializedView serializedView) {
        externalContext.getSessionMap().put(String.valueOf(SERIALIZED_VIEW_ATTR) + "-" + viewId, serializedView);
    }

    protected void removeSerializedViewFromSession(ExternalContext externalContext, String viewId) {
        externalContext.getSessionMap().remove(String.valueOf(SERIALIZED_VIEW_ATTR) + "-" + viewId);
    }

    protected Object getTreeStructureToSave(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.isTransient()) {
            return null;
        }
        return this.buildTreeStructure((UIComponent)viewRoot);
    }

    protected Object getComponentStateToSave(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.isTransient()) {
            return null;
        }
        return viewRoot.processSaveState(context);
    }

    protected TreeStructure buildTreeStructure(UIComponent component) {
        TreeStructure struct = new TreeStructure(component.getClass().getName(), component.getId());
        struct.setChildren(this.buildChildrenTreeStructure(component));
        struct.setFacets(this.buildFacetsTreeStructure(component));
        return struct;
    }

    protected TreeStructure[] buildChildrenTreeStructure(UIComponent component) {
        if (component.getChildCount() > 0) {
            List children = component.getChildren();
            ArrayList<TreeStructure> structs = new ArrayList<TreeStructure>();
            int i = 0;
            while (i < children.size()) {
                UIComponent child = (UIComponent)children.get(i);
                if (!child.isTransient()) {
                    TreeStructure childStruct = this.buildTreeStructure(child);
                    structs.add(childStruct);
                }
                ++i;
            }
            return structs.toArray(new TreeStructure[structs.size()]);
        }
        return null;
    }

    protected Object[] buildFacetsTreeStructure(UIComponent component) {
        Map facets = component.getFacets();
        if (!facets.isEmpty()) {
            ArrayList<Object[]> structs = new ArrayList<Object[]>();
            Iterator it = facets.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                UIComponent child = (UIComponent)entry.getValue();
                if (child.isTransient()) continue;
                String facetName = (String)entry.getKey();
                TreeStructure struct = this.buildTreeStructure(child);
                structs.add(new Object[]{facetName, struct});
            }
            return structs.toArray();
        }
        return null;
    }

    public void writeState(FacesContext context, StateManager.SerializedView serializedView) throws IOException {
        UIViewRoot viewRoot = context.getViewRoot();
        RenderKit renderKit = this.getRenderKit(context, viewRoot.getRenderKitId());
        renderKit.getResponseStateManager().writeState(context, serializedView);
    }

    protected RenderKit getRenderKit(FacesContext context, String renderKitId) {
        return this.getRenderKitFactory().getRenderKit(context, renderKitId);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        UIViewRoot viewRoot = this.restoreTreeStructure(context, viewId, renderKitId);
        if (viewRoot != null) {
            viewRoot.setViewId(viewId);
            this.restoreComponentState(context, viewRoot, renderKitId);
        }
        return viewRoot;
    }

    protected UIViewRoot restoreTreeStructure(FacesContext context, String viewId, String renderKitId) {
        if (this.isSavingStateInClient(context)) {
            return this.restoreTreeStructureFromClient(context, viewId, renderKitId);
        }
        return this.restoreTreeStructureFromServer(context, viewId);
    }

    protected UIViewRoot restoreTreeStructureFromClient(FacesContext context, String viewId, String renderKitId) {
        RenderKit renderKit = this.getRenderKit(context, renderKitId);
        ResponseStateManager responseStateManager = renderKit.getResponseStateManager();
        TreeStructure struct = (TreeStructure)responseStateManager.getTreeStructureToRestore(context, viewId);
        if (struct == null) {
            return null;
        }
        return (UIViewRoot)this.restoreTreeStructure(struct);
    }

    protected UIViewRoot restoreTreeStructureFromServer(FacesContext context, String viewId) {
        StateManager.SerializedView serializedView = this.getSerializedViewFromSession(context.getExternalContext(), viewId);
        if (serializedView == null) {
            return null;
        }
        TreeStructure struct = (TreeStructure)serializedView.getStructure();
        return (UIViewRoot)this.restoreTreeStructure(struct);
    }

    protected UIComponent restoreTreeStructure(TreeStructure struct) {
        String className = struct.getComponentClassName();
        String id = struct.getComponentId();
        UIComponent component = (UIComponent)ClassUtil.newInstance((String)className);
        component.setId(id);
        this.restoreChildrenTreeStructure(component, struct.getChildren());
        this.restoreFacetsTreeStructure(component, struct.getFacets());
        return component;
    }

    protected void restoreChildrenTreeStructure(UIComponent component, TreeStructure[] structs) {
        if (structs != null) {
            int i = 0;
            while (i < structs.length) {
                UIComponent child = this.restoreTreeStructure(structs[i]);
                component.getChildren().add(child);
                ++i;
            }
        }
    }

    protected void restoreFacetsTreeStructure(UIComponent component, Object[] facets) {
        if (facets != null) {
            int i = 0;
            int len = facets.length;
            while (i < len) {
                Object[] array = (Object[])facets[i];
                String facetName = (String)array[0];
                TreeStructure struct = (TreeStructure)array[1];
                UIComponent child = this.restoreTreeStructure(struct);
                component.getFacets().put(facetName, child);
                ++i;
            }
        }
    }

    protected void restoreComponentState(FacesContext context, UIViewRoot viewRoot, String renderKitId) {
        if (viewRoot.getRenderKitId() == null) {
            viewRoot.setRenderKitId(renderKitId);
        }
        if (this.isSavingStateInClient(context)) {
            this.restoreComponentStateFromClient(context, viewRoot, renderKitId);
        } else {
            this.restoreComponentStateFromServer(context, viewRoot);
        }
    }

    protected void restoreComponentStateFromClient(FacesContext context, UIViewRoot viewRoot, String renderKitId) {
        RenderKit renderKit = this.getRenderKit(context, renderKitId);
        ResponseStateManager responseStateManager = renderKit.getResponseStateManager();
        Object state = responseStateManager.getComponentStateToRestore(context);
        viewRoot.processRestoreState(context, state);
    }

    protected void restoreComponentStateFromServer(FacesContext context, UIViewRoot viewRoot) {
        StateManager.SerializedView serializedView = this.getSerializedViewFromSession(context.getExternalContext(), viewRoot.getViewId());
        if (serializedView == null) {
            return;
        }
        Object state = serializedView.getState();
        if (state == null) {
            return;
        }
        viewRoot.processRestoreState(context, state);
    }

    protected RenderKitFactory getRenderKitFactory() {
        if (this.renderKitFactory == null) {
            this.renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        }
        return this.renderKitFactory;
    }
}

