package org.seasar.extension.jdbc.impl;

import java.sql.CallableStatement;
import java.sql.Connection;

import org.seasar.extension.jdbc.CallableStatementFactory;
import org.seasar.framework.util.ConnectionUtil;

/**
 * @author higa
 *
 */
public class BasicCallableStatementFactory implements CallableStatementFactory {
	
	public static final CallableStatementFactory INSTANCE = new BasicCallableStatementFactory();
	
	/**
	 * @see org.seasar.extension.jdbc.CallableStatementFactory#createCallableStatement(java.sql.Connection, java.lang.String)
	 */
	public CallableStatement createCallableStatement(Connection con, String sql) {
		return ConnectionUtil.prepareCall(con, sql);
	}
}
