package org.seasar.hibernate.filter;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.seasar.hibernate.S2Session;
import org.seasar.hibernate.S2SessionFactory;

/**
 * @author kenichi_okazaki
 *
 */
public class FilterChainTxImpl implements FilterChainTx {

	private S2SessionFactory sessionFactory_;
	private String requestAttributeName_ = "S2Session";

	public FilterChainTxImpl(S2SessionFactory sessionFactory) {
		sessionFactory_ = sessionFactory;
	}

	public void doFilter(
		ServletRequest request,
		ServletResponse response,
		FilterChain chain)
		throws IOException, ServletException {

		S2Session s2session = sessionFactory_.getSession();
		request.setAttribute(requestAttributeName_, s2session);

		chain.doFilter(request, response);
	}

	public void setRequestAttributeName(String requestAttributeName) {
		requestAttributeName_ = requestAttributeName;
	}

}
