package examples.hibernate.dao;

import java.util.List;

import examples.hibernate.entity.Department;

public interface DepartmentAutoDao {
	public Class BEAN = Department.class;

	//load
	public Department load(short empno);

	//ListĂꍇ
	public String getDepartmentByDeptno_ARGS = "deptno";
	public String getDepartmentByDeptno_EAGER = "employee";
	public Department getDepartmentByDeptno( int deptno );

	public String findAll_EAGER = "employee";
	public List findAll( );
	
	//public String getDept_HQL = "from Department as d where d.deptno = :deptno";
//	public String getDept_HQL = "select d from Department as d where d.deptno = :deptno";
	public String getDept_HQL = "from Department as d where d.deptno = :deptno";
	public String getDept_ARGS = "deptno";
	public Department getDept(short deptno);

	public String getDeptName_HQL = "select d.dname from Department as d where d.deptno = :deptno";
	public String getDeptName_ARGS = "deptno";
	public String getDeptName(short deptno);
	
}
