/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.ObjectExistsException;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.Configurator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheManager
implements Serializable {
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$CacheManager == null ? (class$net$sf$ehcache$CacheManager = CacheManager.class$("net.sf.ehcache.CacheManager")) : class$net$sf$ehcache$CacheManager).getName());
    private Configuration configuration;
    private String configurationFileName;
    private URL configurationURL;
    private Hashtable caches = new Hashtable();
    private Cache defaultCache;
    private String diskStorePath;
    private static CacheManager instance;
    private int status = 1;
    public static final int STATUS_UNINITIALISED = 1;
    public static final int STATUS_ALIVE = 2;
    public static final int STATUS_SHUTDOWN = 3;
    static /* synthetic */ Class class$net$sf$ehcache$CacheManager;

    private CacheManager(String configurationFileName) throws CacheException {
        this.configurationFileName = configurationFileName;
        this.configure();
        this.status = 2;
    }

    private CacheManager(URL configurationFileURL) throws CacheException {
        this.configurationURL = configurationFileURL;
        this.configure();
        this.status = 2;
    }

    private CacheManager() throws CacheException {
        this.configure();
        this.status = 2;
    }

    private synchronized void configure() throws CacheException {
        if (this.defaultCache != null || this.diskStorePath != null || this.caches.size() != 0 || this.status == 3) {
            throw new IllegalStateException("Attempt to reinitialise the Store Manager");
        }
        this.configuration = new Configuration();
        try {
            Configurator configurator = new Configurator();
            if (this.configurationFileName != null) {
                configurator.configure((Object)this.configuration, new File(this.configurationFileName));
            } else if (this.configurationURL != null) {
                configurator.configure((Object)this.configuration, this.configurationURL);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Configuring ehcache from classpath.");
                }
                configurator.configure(this.configuration);
            }
        }
        catch (Exception e) {
            throw new CacheException("Cannot configure CacheManager: " + e.getMessage());
        }
        this.defaultCache = this.configuration.getDefaultCache();
        this.diskStorePath = this.configuration.getDiskCachePath();
        Set configuredCacheKeys = this.configuration.getCacheKeySet();
        Iterator iterator = configuredCacheKeys.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            this.addCacheNoCheck(this.configuration.getCache(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create() throws CacheException {
        Class clazz = class$net$sf$ehcache$CacheManager == null ? (class$net$sf$ehcache$CacheManager = CacheManager.class$("net.sf.ehcache.CacheManager")) : class$net$sf$ehcache$CacheManager;
        synchronized (clazz) {
            if (instance == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Creating new CacheManager with default config");
                }
                instance = new CacheManager();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Attempting to create an existing instance. Existing instance returned.");
            }
            return instance;
        }
    }

    public static CacheManager getInstance() throws CacheException {
        return CacheManager.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(String configurationFileName) throws CacheException {
        Class clazz = class$net$sf$ehcache$CacheManager == null ? (class$net$sf$ehcache$CacheManager = CacheManager.class$("net.sf.ehcache.CacheManager")) : class$net$sf$ehcache$CacheManager;
        synchronized (clazz) {
            if (instance == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Creating new CacheManager with config file: " + configurationFileName));
                }
                instance = new CacheManager(configurationFileName);
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(URL configurationFileURL) throws CacheException {
        Class clazz = class$net$sf$ehcache$CacheManager == null ? (class$net$sf$ehcache$CacheManager = CacheManager.class$("net.sf.ehcache.CacheManager")) : class$net$sf$ehcache$CacheManager;
        synchronized (clazz) {
            if (instance == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Creating new CacheManager with config URL: " + configurationFileURL));
                }
                instance = new CacheManager(configurationFileURL);
            }
            return instance;
        }
    }

    public synchronized Cache getCache(String name) throws IllegalStateException {
        this.checkStatus();
        return (Cache)this.caches.get(name);
    }

    public synchronized void addCache(String cacheName) throws IllegalStateException, ObjectExistsException, CacheException {
        this.checkStatus();
        if (this.caches.get(cacheName) != null) {
            throw new ObjectExistsException("Cache " + cacheName + " already exists");
        }
        Cache cache = null;
        try {
            cache = (Cache)this.defaultCache.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Object)"Failure adding cache", (Throwable)e);
        }
        cache.setName(cacheName);
        this.addCache(cache);
    }

    public synchronized void addCache(Cache cache) throws IllegalStateException, ObjectExistsException, CacheException {
        this.checkStatus();
        this.addCacheNoCheck(cache);
    }

    private synchronized void addCacheNoCheck(Cache cache) throws IllegalStateException, ObjectExistsException, CacheException {
        if (this.caches.get(cache.getName()) != null) {
            throw new ObjectExistsException("Cache " + cache.getName() + " already exists");
        }
        cache.initialise(this.configuration);
        this.caches.put(cache.getName(), cache);
    }

    public synchronized boolean cacheExists(String cacheName) throws IllegalStateException {
        this.checkStatus();
        return this.caches.get(cacheName) != null;
    }

    public synchronized void removeCache(String cacheName) throws IllegalStateException {
        this.checkStatus();
        Cache cache = (Cache)this.caches.remove(cacheName);
        if (cache != null) {
            cache.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.status == 3) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"CacheManager already shutdown");
            }
            return;
        }
        Serializable serializable = this;
        synchronized (serializable) {
            Enumeration allCaches = this.caches.elements();
            while (allCaches.hasMoreElements()) {
                Cache cache = (Cache)allCaches.nextElement();
                if (cache == null) continue;
                cache.dispose();
            }
            this.status = 3;
        }
        serializable = class$net$sf$ehcache$CacheManager == null ? (class$net$sf$ehcache$CacheManager = CacheManager.class$("net.sf.ehcache.CacheManager")) : class$net$sf$ehcache$CacheManager;
        synchronized (serializable) {
            instance = null;
        }
    }

    public synchronized String[] getCacheNames() throws IllegalStateException {
        this.checkStatus();
        String[] list = new String[this.caches.size()];
        return this.caches.keySet().toArray(list);
    }

    Configuration getConfiguration() throws IllegalStateException {
        this.checkStatus();
        return this.configuration;
    }

    private void checkStatus() {
        if (this.status != 2) {
            throw new IllegalStateException("The CacheManager is not alive.");
        }
    }

    public int getStatus() {
        return this.status;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

