/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.exception.Nestable;

public class NestableDelegate
implements Serializable {
    private static final transient String MUST_BE_THROWABLE = "The Nestable implementation passed to the NestableDelegate(Nestable) constructor must extend java.lang.Throwable";
    private Throwable nestable = null;
    static /* synthetic */ Class class$org$apache$commons$lang$exception$Nestable;

    NestableDelegate(Nestable nestable) {
        if (!(nestable instanceof Throwable)) {
            throw new IllegalArgumentException(MUST_BE_THROWABLE);
        }
        this.nestable = (Throwable)((Object)nestable);
    }

    String getMessage(int index) {
        Throwable t;
        if ((class$org$apache$commons$lang$exception$Nestable == null ? (class$org$apache$commons$lang$exception$Nestable = NestableDelegate.class$("org.apache.commons.lang.exception.Nestable")) : class$org$apache$commons$lang$exception$Nestable).isInstance(t = this.getThrowable(index))) {
            return ((Nestable)((Object)t)).getMessage(0);
        }
        return t.getMessage();
    }

    String getMessage(String baseMsg) {
        String causeMsg;
        Throwable nestedCause;
        StringBuffer msg = new StringBuffer();
        if (baseMsg != null) {
            msg.append(baseMsg);
        }
        if ((nestedCause = ExceptionUtils.getCause(this.nestable)) != null && (causeMsg = nestedCause.getMessage()) != null) {
            if (baseMsg != null) {
                msg.append(": ");
            }
            msg.append(causeMsg);
        }
        return msg.length() > 0 ? msg.toString() : null;
    }

    String[] getMessages() {
        Throwable[] throwables = this.getThrowables();
        String[] msgs = new String[throwables.length];
        int i = 0;
        while (i < throwables.length) {
            msgs[i] = (class$org$apache$commons$lang$exception$Nestable == null ? NestableDelegate.class$("org.apache.commons.lang.exception.Nestable") : class$org$apache$commons$lang$exception$Nestable).isInstance(throwables[i]) ? ((Nestable)((Object)throwables[i])).getMessage(0) : throwables[i].getMessage();
            ++i;
        }
        return msgs;
    }

    Throwable getThrowable(int index) {
        if (index == 0) {
            return this.nestable;
        }
        Throwable[] throwables = this.getThrowables();
        return throwables[index];
    }

    int getThrowableCount() {
        return ExceptionUtils.getThrowableCount(this.nestable);
    }

    Throwable[] getThrowables() {
        return ExceptionUtils.getThrowables(this.nestable);
    }

    int indexOfThrowable(Class type, int fromIndex) {
        return ExceptionUtils.indexOfThrowable(this.nestable, type, fromIndex);
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream out) {
        PrintStream printStream = out;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(out, false);
            this.printStackTrace(pw);
            pw.flush();
        }
    }

    public void printStackTrace(PrintWriter out) {
        PrintWriter printWriter = out;
        synchronized (printWriter) {
            String[] st = this.getStackFrames(this.nestable);
            Throwable nestedCause = ExceptionUtils.getCause(this.nestable);
            if (nestedCause != null) {
                if (nestedCause instanceof Nestable) {
                    ((Nestable)((Object)nestedCause)).printStackTrace(out);
                } else {
                    String[] nst = this.getStackFrames(nestedCause);
                    int i = 0;
                    while (i < nst.length) {
                        out.println(nst[i]);
                        ++i;
                    }
                }
                out.print("rethrown as ");
            }
            int i = 0;
            while (i < st.length) {
                out.println(st[i]);
                ++i;
            }
        }
    }

    private String[] getStackFrames(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        if (t instanceof Nestable) {
            ((Nestable)((Object)t)).printPartialStackTrace(pw);
        } else {
            t.printStackTrace(pw);
        }
        return ExceptionUtils.getStackFrames(sw.getBuffer().toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

