/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.httpunit.mock;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.RequestUtil;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.seasar.framework.container.S2Container;
import org.seasar.httpunit.mock.AttributeFacade;
import org.seasar.httpunit.mock.MockHttpServletRequest;
import org.seasar.httpunit.mock.MockHttpSession;

public class HttpServletRequestDelegator
extends AttributeFacade {
    private static SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    private RequestDispatcher requestDispatcher;
    private MockHttpServletRequest request;
    private MockHttpSession session;
    private ServletContext context;
    private S2Container container;
    private Map parameters = new HashMap();
    private List cookies = new ArrayList();
    private Hashtable headers = new Hashtable();
    static /* synthetic */ Class class$org$seasar$httpunit$mock$MockHttpSession;

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public void setServletContext(ServletContext context) {
        this.context = context;
    }

    public HttpSession getSession(boolean create) {
        if (this.session == null && create) {
            this.session = this.createHttpSessionObject();
        } else if (this.session != null && this.session.isValid() && create) {
            this.session = this.createHttpSessionObject();
            this.session.setValid(false);
        }
        if (this.session != null && !this.session.isValid()) {
            return this.session;
        }
        return null;
    }

    private MockHttpSession createHttpSessionObject() {
        return (MockHttpSession)this.container.getComponent((Object)(class$org$seasar$httpunit$mock$MockHttpSession == null ? (class$org$seasar$httpunit$mock$MockHttpSession = HttpServletRequestDelegator.class$("org.seasar.httpunit.mock.MockHttpSession")) : class$org$seasar$httpunit$mock$MockHttpSession));
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public Cookie[] getCookies() {
        if (this.cookies.isEmpty()) {
            return null;
        }
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public String getHeader(String name) {
        return (String)this.headers.get(name);
    }

    public Enumeration getHeaders(String name) {
        return new StringTokenizer(this.getHeader(name), ",");
    }

    public Enumeration getHeaderNames() {
        return this.headers.keys();
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        long result = FastHttpDateFormat.parseDate((String)value, (DateFormat[])formats);
        if (result != -1L) {
            return result;
        }
        throw new IllegalArgumentException(value);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.requestDispatcher;
    }

    public void setRequestDispatcher(RequestDispatcher requestDispatcher) {
        this.requestDispatcher = requestDispatcher;
    }

    public void setHttpServletRequest(MockHttpServletRequest httpServletRequest) {
        this.request = httpServletRequest;
    }

    public String getParameter(String name) {
        this.parseParameters();
        Object value = this.parameters.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof String[]) {
            return ((String[])value)[0];
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public Map getParameterMap() {
        this.parseParameters();
        return this.parameters;
    }

    public Enumeration getParameterNames() {
        this.parseParameters();
        return new Enumerator(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        this.parseParameters();
        Object value = this.parameters.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof String) {
            String[] values = new String[]{(String)value};
            return values;
        }
        String[] values = new String[]{value.toString()};
        return values;
    }

    public String getPathTranslated() {
        if (this.context == null) {
            return null;
        }
        if (this.request.getPathInfo() == null) {
            return null;
        }
        return this.context.getRealPath(this.request.getPathInfo());
    }

    public int getIntHeader(String name) {
        String value = this.request.getHeader(name);
        if (value == null) {
            return -1;
        }
        int ret = Integer.parseInt(value);
        return ret;
    }

    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void addParameter(String name, String[] values) {
        this.parameters.put(name, values);
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    private void parseParameters() {
        String queryParamString = this.request.getQueryString();
        if (queryParamString == null || queryParamString.length() < 1) {
            return;
        }
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        String encoding = this.request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        try {
            RequestUtil.parseParameters(queryParameters, (String)queryParamString, (String)encoding);
        }
        catch (Exception e) {
            // empty catch block
        }
        Iterator keys = this.parameters.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = queryParameters.get(key);
            if (value == null) {
                queryParameters.put(key, this.parameters.get(key));
                continue;
            }
            queryParameters.put(key, this.mergeValues(value, this.parameters.get(key)));
        }
        this.parameters.putAll(queryParameters);
    }

    private String[] mergeValues(Object values1, Object values2) {
        ArrayList results = new ArrayList();
        this.addStringValues(results, values1);
        this.addStringValues(results, values2);
        String[] values = new String[results.size()];
        return results.toArray(values);
    }

    private void addStringValues(List list, Object value) {
        if (value != null) {
            if (value instanceof String) {
                list.add(value);
            } else if (value instanceof String[]) {
                String[] values = (String[])value;
                for (int i = 0; i < values.length; ++i) {
                    list.add(values[i]);
                }
            } else {
                list.add(value.toString());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

