package org.seasar.framework.container.deployer;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.util.InstanceModeUtil;

/**
 * @author higa
 *
 */
public final class ComponentDeployerFactory {

	private ComponentDeployerFactory() {
	}

	public static ComponentDeployer create(ComponentDef componentDef) {
		if (InstanceModeUtil.isSingleton(componentDef.getInstanceMode())) {
			return new SingletonComponentDeployer(componentDef);
		} else if (InstanceModeUtil.isPrototype(componentDef.getInstanceMode())) {
			return new PrototypeComponentDeployer(componentDef);
		} else if (InstanceModeUtil.isRequest(componentDef.getInstanceMode())) {
			return new RequestComponentDeployer(componentDef);
		} else if (InstanceModeUtil.isSession(componentDef.getInstanceMode())) {
			return new SessionComponentDeployer(componentDef);
		} else {
			return new OuterComponentDeployer(componentDef);
		}
	}
}
