/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.framework.util.DecimalFormatUtil;

public final class IntegerConversionUtil {
    private IntegerConversionUtil() {
    }

    public static Integer toInteger(Object o) {
        return IntegerConversionUtil.toInteger(o, null);
    }

    public static Integer toInteger(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Number) {
            return new Integer(((Number)o).intValue());
        }
        if (o instanceof String) {
            return IntegerConversionUtil.toInteger((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new Integer(new SimpleDateFormat(pattern).format(o));
            }
            return new Integer((int)((Date)o).getTime());
        }
        return IntegerConversionUtil.toInteger(o.toString());
    }

    private static Integer toInteger(String s) {
        return new Integer(DecimalFormatUtil.normalize(s));
    }

    public static int toPrimitiveInt(Object o) {
        return IntegerConversionUtil.toPrimitiveInt(o, null);
    }

    public static int toPrimitiveInt(Object o, String pattern) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof String) {
            return IntegerConversionUtil.toPrimitiveInt((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return Integer.parseInt(new SimpleDateFormat(pattern).format(o));
            }
            return (int)((Date)o).getTime();
        }
        return IntegerConversionUtil.toPrimitiveInt(o.toString());
    }

    private static int toPrimitiveInt(String s) {
        return Integer.parseInt(DecimalFormatUtil.normalize(s));
    }
}

