/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.RequestEntity;

public class StringRequestEntity
implements RequestEntity {
    private String content;
    private String charset;
    private String contentType;

    public StringRequestEntity(String content) {
        this(content, null, null);
    }

    public StringRequestEntity(String content, String contentType, String charset) {
        if (content == null) {
            throw new IllegalArgumentException("The content cannot be null");
        }
        this.content = content;
        this.contentType = contentType;
        this.charset = charset;
        if (contentType != null) {
            HeaderElement[] values = HeaderElement.parseElements(contentType);
            NameValuePair charsetPair = null;
            int i = 0;
            while (i < values.length) {
                charsetPair = values[i].getParameterByName("charset");
                if (charsetPair != null) break;
                ++i;
            }
            if (charset == null && charsetPair != null) {
                this.charset = charsetPair.getValue();
            } else if (charset != null && charsetPair == null) {
                this.contentType = contentType + "; charset=" + charset;
            }
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isRepeatable() {
        return true;
    }

    public void writeRequest(OutputStream out) throws IOException {
        OutputStreamWriter writer = null;
        writer = this.charset != null ? new OutputStreamWriter(out, this.charset) : new OutputStreamWriter(out);
        writer.write(this.content);
        ((Writer)writer).flush();
    }

    public long getContentLength() {
        return this.content.length();
    }

    public String getContent() {
        return this.content;
    }

    public String getCharset() {
        return this.charset;
    }
}

