package org.seasar.struts.taglib.html;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;

import org.apache.struts.taglib.TagUtils;
import org.apache.struts.taglib.logic.IterateTag;

/**
 * @author Satoshi Kimura
 */
public class ButtonTag extends org.apache.struts.taglib.html.ButtonTag {
    private String type;
    private String valueStartIndex;
    private String value;
    private int startIndex;

    /**
     * @param type The type to set.
     */
    public void setType(String type) {
        this.type = type;
    }
    public void setValueStartIndex(String index) {
        valueStartIndex = index;
        startIndex = Integer.parseInt(index);
    }
    /**
     * @param value The value to set.
     */
    public void setValue(String value) {
        this.value = value;
    }
    /**
     * Process the end of this tag.
     * <p>
     * Support for indexed property since Struts 1.1
     * 
     * @exception JspException if a JSP exception has occurred
     */
    public int doStartTag() throws JspException {

        // Generate an HTML element
        StringBuffer results = new StringBuffer();
        results.append("<button");
        if (type != null) {
            results.append(" type=\"");
            results.append(type);
            results.append("\"");
        }
        if (property != null) {
            results.append(" name=\"");
            results.append(property);
            if (indexed)
                prepareIndex(results, null);
            results.append("\"");
        }
        if (accesskey != null) {
            results.append(" accesskey=\"");
            results.append(accesskey);
            results.append("\"");
        }
        if (tabindex != null) {
            results.append(" tabindex=\"");
            results.append(tabindex);
            results.append("\"");
        }
        if (valueStartIndex != null) {
            IterateTag iterateTag = getIterateTag(this);
            results.append(" value=\"");
            results.append(iterateTag.getIndex() + startIndex);
            results.append("\"");
        } else {
            results.append(" value=\"");
            results.append(value);
            results.append("\"");
        }
        results.append(prepareEventHandlers());
        results.append(prepareStyles());
        results.append(getElementClose());

        // Render this element to our writer
        TagUtils.getInstance().write(pageContext, results.toString());

        // Evaluate the remainder of this page
        return (EVAL_BODY_INCLUDE);

    }
    public int doEndTag() throws JspException {
        TagUtils.getInstance().write(pageContext, "</button>");
        return (EVAL_PAGE);
        
    }
    
    public int doAfterBody() throws JspException {
        return SKIP_BODY;
    }

    private IterateTag getIterateTag(Tag tag) {
        Tag parentTag = tag.getParent();
        if (parentTag instanceof IterateTag) {
            return (IterateTag) parentTag;
        } else {
            if (parentTag == null) {
                return null;
            } else {
                return getIterateTag(parentTag);
            }
        }
    }
}