/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.custom.date;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class HtmlInputDate
extends UIInput {
    public static final String COMPONENT_TYPE = "net.sourceforge.myfaces.HtmlInputDate";
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    private static final String DEFAULT_RENDERER_TYPE = "net.sourceforge.myfaces.Date";
    private static final boolean DEFAULT_DISABLED = false;
    private String _type = null;
    private Boolean _disabled = null;
    private UserData _userData = null;

    public HtmlInputDate() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public void setUserData(UserData userData) {
        this._userData = userData;
    }

    public UserData getUserData(Locale currentLocale) {
        if (this._userData == null) {
            this._userData = new UserData((Date)this.getValue(), currentLocale);
        }
        return this._userData;
    }

    public String getType() {
        if (this._type != null) {
            return this._type;
        }
        ValueBinding vb = this.getValueBinding("type");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "date";
    }

    public void setType(String string) {
        this._type = string;
    }

    public boolean isDisabled() {
        if (this._disabled != null) {
            return this._disabled;
        }
        ValueBinding vb = this.getValueBinding("disabled");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : false;
    }

    public void setDisabled(boolean disabled) {
        this._disabled = disabled;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._type, this._disabled, this._userData};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._type = (String)values[1];
        this._disabled = (Boolean)values[2];
        this._userData = (UserData)values[3];
    }

    public static class UserData
    implements Serializable {
        private String day = null;
        private String month = null;
        private String year = null;
        private String hours = null;
        private String minutes = null;
        private String seconds = null;

        public UserData(Date date, Locale currentLocale) {
            if (date != null) {
                Calendar calendar = Calendar.getInstance(currentLocale);
                calendar.setTime(date);
                this.day = Integer.toString(calendar.get(5));
                this.month = Integer.toString(calendar.get(2) + 1);
                this.year = Integer.toString(calendar.get(1));
                this.hours = Integer.toString(calendar.get(11));
                this.minutes = Integer.toString(calendar.get(12));
                this.seconds = Integer.toString(calendar.get(13));
            }
        }

        public Date parse() throws ParseException {
            SimpleDateFormat fullFormat = new SimpleDateFormat("dd MM yyyy hh mm ss");
            return fullFormat.parse(this.day + " " + this.month + " " + this.year + " " + this.hours + " " + this.minutes + " " + this.seconds);
        }

        private String formatedInt(String toFormat) {
            if (toFormat == null) {
                return null;
            }
            int i = -1;
            try {
                i = Integer.parseInt(toFormat);
            }
            catch (NumberFormatException nfe) {
                return toFormat;
            }
            if (i >= 0 && i < 10) {
                return "0" + i;
            }
            return Integer.toString(i);
        }

        public String getDay() {
            return this.formatedInt(this.day);
        }

        public void setDay(String day) {
            this.day = day;
        }

        public String getMonth() {
            return this.month;
        }

        public void setMonth(String month) {
            this.month = month;
        }

        public String getYear() {
            return this.year;
        }

        public void setYear(String year) {
            this.year = year;
        }

        public String getHours() {
            return this.formatedInt(this.hours);
        }

        public void setHours(String hours) {
            this.hours = hours;
        }

        public String getMinutes() {
            return this.formatedInt(this.minutes);
        }

        public void setMinutes(String minutes) {
            this.minutes = minutes;
        }

        public String getSeconds() {
            return this.formatedInt(this.seconds);
        }

        public void setSeconds(String seconds) {
            this.seconds = seconds;
        }
    }
}

